/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common;

import java.net.URL;
import javax.management.ObjectName;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.wsf.spi.deployment.EndpointState;

@MessageLogger(projectCode="JBWS")
public interface Loggers
extends BasicLogger {
    public static final Loggers ROOT_LOGGER = (Loggers)Logger.getMessageLogger(Loggers.class, (String)"org.jboss.ws.common");
    public static final Loggers MONITORING_LOGGER = (Loggers)Logger.getMessageLogger(Loggers.class, (String)"org.jboss.ws.common.monitoring");
    public static final Loggers MANAGEMENT_LOGGER = (Loggers)Logger.getMessageLogger(Loggers.class, (String)"org.jboss.ws.common.management");
    public static final Loggers DEPLOYMENT_LOGGER = (Loggers)Logger.getMessageLogger(Loggers.class, (String)"org.jboss.ws.common.deployment");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22001, value="Cannot get children for resource %s")
    public void cannotGetChildrenForResource(@Cause Throwable var1, URL var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22002, value="Cannot get name for resource %s")
    public void cannotGetNameForResource(@Cause Throwable var1, URL var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22010, value="Class %s is not assignable from %s due to conflicting classloaders: %s and %s")
    public void notAssignableDueToConflictingClassLoaders(Class<?> var1, Class<?> var2, ClassLoader var3, ClassLoader var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22011, value="Could not clear blacklist for classloader %s")
    public void couldNotClearBlacklist(ClassLoader var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22012, value="Could not load %s")
    public void couldNotLoad(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22013, value="Cannot parse: %s")
    public void cannotParse(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22021, value="Cannot read resource: %s")
    public void cannotReadResource(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22022, value="Cannot load ID '%s' as URL (protocol = %s)")
    public void cannotLoadIDAsURL(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22025, value="WSDL import published to %s")
    public void wsdlImportPublishedTo(URL var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22026, value="XMLSchema import published to %s")
    public void xmlSchemaImportPublishedTo(URL var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22027, value="Cannot delete published wsdl document: %s")
    public void cannotDeletePublishedWsdlDoc(URL var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22042, value="Cannot register processor %s with JMX server, will be trying using the default managed implementation. ")
    public void cannotRegisterProvidedProcessor(ObjectName var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22043, value="Cannot register processor %s with JMX server")
    public void cannotRegisterProcessorWithJmxServer(ObjectName var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22044, value="Cannot unregister processor %s with JMX server")
    public void cannotUnregisterProcessorWithJmxServer(ObjectName var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22052, value="Starting %s %s")
    public void startingWSServerConfig(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22053, value="Unable to calculate webservices port, using default %s")
    public void unableToCalculateWebServicesPort(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22054, value="Unable to calculate webservices secure port, using default %s")
    public void unableToCalculateWebServicesSecurePort(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22055, value="Using undefined webservices host: %s")
    public void usingUndefinedWebServicesHost(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22056, value="Setting webservices host to localhost: %s")
    public void usingLocalHostWebServicesHost(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22057, value="Could not get address for host: %s")
    public void couldNotGetAddressForHost(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22058, value="Could not get port for webservices configuration from configured HTTP connector")
    public void couldNotGetPortFromConfiguredHTTPConnector();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22059, value="Unable to read from the http servlet request")
    public void unableToReadFromHttpServletRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22060, value="Cannot trace SOAP message")
    public void cannotTraceSoapMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22061, value="Method invocation failed with exception")
    public void methodInvocationFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22090, value="Cannot get %s from root file, trying with additional metadata files")
    public void cannotGetRootFileTryingWithAdditionalMetaData(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22098, value="Cannot get %s from %s")
    public void cannotGetRootResourceFrom(String var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=22099, value="Error during deployment: %s")
    public void errorDuringDeployment(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22100, value="Error while destroying deployment %s due to previous exception")
    public void errorDestroyingDeployment(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22102, value="Cannot stop endpoint in state %s: %s")
    public void cannotStopEndpoint(EndpointState var1, ObjectName var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22103, value="Cannot start endpoint in state %s: %s")
    public void cannotStartEndpoint(EndpointState var1, ObjectName var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22110, value="Could not add handler %s as part of client or endpoint configuration")
    public void cannotAddHandler(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22111, value="PortNamePattern and ServiceNamePattern filters not supported; adding handlers anyway")
    public void filtersNotSupported();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22112, value="Init params not supported; adding handler anyway")
    public void initParamsNotSupported();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22113, value="Error closing JAXBIntro configuration stream: %s")
    public void errorClosingJAXBIntroConf(URL var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22114, value="%s doesn't work on %s")
    public void aspectDoesNotWorkOnDeployment(Class<?> var1, Class<?> var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22115, value="Cannot get URL for %s")
    public void cannotGetURLFor(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=22116, value="Could not find %s in the additional metadatafiles")
    public void cannotFindInAdditionalMetaData(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22118, value="Cannot obtain host for vituralHost %s, use default host")
    public void cannotObtainHost(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22119, value="Cannot obtain port for vituralHost %s, use default port")
    public void cannotObtainPort(String var1);
}

