/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.utils.ClassLoadingUtils;
import org.jboss.as.ejb3.component.ContainerInterceptorMethodInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.modules.Module;

public class EJBContainerInterceptorsViewConfigurator
implements ViewConfigurator {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final EJBContainerInterceptorsViewConfigurator INSTANCE = new EJBContainerInterceptorsViewConfigurator();

    private EJBContainerInterceptorsViewConfigurator() {
    }

    public void configure(DeploymentPhaseContext deploymentPhaseContext, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        ComponentDescription componentDescription = componentConfiguration.getComponentDescription();
        if (!(componentDescription instanceof EJBComponentDescription)) {
            return;
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
        Set<InterceptorDescription> allContainerInterceptors = ejbComponentDescription.getAllContainerInterceptors();
        if (allContainerInterceptors == null || allContainerInterceptors.isEmpty()) {
            return;
        }
        this.doConfigure(deploymentPhaseContext, ejbComponentDescription, viewConfiguration);
    }

    private void doConfigure(DeploymentPhaseContext context, EJBComponentDescription ejbComponentDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        HashMap<String, List<InterceptorFactory>> userAroundInvokesByInterceptorClass = new HashMap<String, List<InterceptorFactory>>();
        HashMap<String, List<InterceptorFactory>> userAroundTimeoutsByInterceptorClass = ejbComponentDescription.isTimerServiceRequired() ? new HashMap<String, List<InterceptorFactory>>() : null;
        for (InterceptorDescription interceptorDescription : ejbComponentDescription.getAllContainerInterceptors()) {
            List<InterceptorFactory> aroundTimeoutInterceptorFactories;
            Class intereptorClass;
            String interceptorClassName = interceptorDescription.getInterceptorClassName();
            try {
                intereptorClass = ClassLoadingUtils.loadClass((String)interceptorClassName, (Module)module);
            }
            catch (ClassNotFoundException e) {
                throw EeLogger.ROOT_LOGGER.cannotLoadInterceptor((Throwable)e, interceptorClassName);
            }
            InterceptorClassDescriptionTraversal interceptorClassDescriptionTraversal = new InterceptorClassDescriptionTraversal(intereptorClass, applicationClasses, deploymentUnit, ejbComponentDescription);
            interceptorClassDescriptionTraversal.run();
            List<InterceptorFactory> aroundInvokeInterceptorFactories = interceptorClassDescriptionTraversal.getAroundInvokeInterceptorFactories();
            if (aroundInvokeInterceptorFactories != null) {
                userAroundInvokesByInterceptorClass.put(interceptorClassName, aroundInvokeInterceptorFactories);
            }
            if (!ejbComponentDescription.isTimerServiceRequired() || (aroundTimeoutInterceptorFactories = interceptorClassDescriptionTraversal.getAroundTimeoutInterceptorFactories()) == null) continue;
            userAroundTimeoutsByInterceptorClass.put(interceptorClassName, aroundTimeoutInterceptorFactories);
        }
        List<InterceptorDescription> classLevelContainerInterceptors = ejbComponentDescription.getClassLevelContainerInterceptors();
        Map<MethodIdentifier, List<InterceptorDescription>> methodLevelContainerInterceptors = ejbComponentDescription.getMethodLevelContainerInterceptors();
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        for (Method method : viewMethods) {
            List<InterceptorDescription> interceptorsForMethod;
            List aroundTimeoutsOnInterceptor;
            List aroundInvokesOnInterceptor;
            String interceptorClassName;
            MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
            ArrayList<InterceptorFactory> aroundInvokesApplicableForMethod = new ArrayList<InterceptorFactory>();
            ArrayList<InterceptorFactory> aroundTimeoutsApplicableForMethod = new ArrayList<InterceptorFactory>();
            if (!ejbComponentDescription.isExcludeDefaultContainerInterceptors() && !ejbComponentDescription.isExcludeDefaultContainerInterceptors(methodIdentifier)) {
                for (InterceptorDescription interceptorDescription : ejbComponentDescription.getDefaultContainerInterceptors()) {
                    interceptorClassName = interceptorDescription.getInterceptorClassName();
                    aroundInvokesOnInterceptor = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                    if (aroundInvokesOnInterceptor != null) {
                        aroundInvokesApplicableForMethod.addAll(aroundInvokesOnInterceptor);
                    }
                    if (!ejbComponentDescription.isTimerServiceRequired() || (aroundTimeoutsOnInterceptor = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                    aroundTimeoutsApplicableForMethod.addAll(aroundTimeoutsOnInterceptor);
                }
            }
            if (!ejbComponentDescription.isExcludeClassLevelContainerInterceptors(methodIdentifier)) {
                for (InterceptorDescription interceptorDescription : classLevelContainerInterceptors) {
                    interceptorClassName = interceptorDescription.getInterceptorClassName();
                    aroundInvokesOnInterceptor = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                    if (aroundInvokesOnInterceptor != null) {
                        aroundInvokesApplicableForMethod.addAll(aroundInvokesOnInterceptor);
                    }
                    if (!ejbComponentDescription.isTimerServiceRequired() || (aroundTimeoutsOnInterceptor = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName)) == null) continue;
                    aroundTimeoutsApplicableForMethod.addAll(aroundTimeoutsOnInterceptor);
                }
            }
            if ((interceptorsForMethod = methodLevelContainerInterceptors.get(methodIdentifier)) != null) {
                for (InterceptorDescription methodLevelInterceptor : interceptorsForMethod) {
                    List aroundTimeoutsOnInterceptor2;
                    String interceptorClassName2 = methodLevelInterceptor.getInterceptorClassName();
                    List aroundInvokesOnInterceptor2 = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName2);
                    if (aroundInvokesOnInterceptor2 != null) {
                        aroundInvokesApplicableForMethod.addAll(aroundInvokesOnInterceptor2);
                    }
                    if (!ejbComponentDescription.isTimerServiceRequired() || (aroundTimeoutsOnInterceptor2 = (List)userAroundTimeoutsByInterceptorClass.get(interceptorClassName2)) == null) continue;
                    aroundTimeoutsApplicableForMethod.addAll(aroundTimeoutsOnInterceptor2);
                }
            }
            viewConfiguration.addViewInterceptor(method, (InterceptorFactory)new UserInterceptorFactory(EJBContainerInterceptorsViewConfigurator.weaved(aroundInvokesApplicableForMethod), EJBContainerInterceptorsViewConfigurator.weaved(aroundTimeoutsApplicableForMethod)), 585);
        }
    }

    private static InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }

    private static Object newInstance(Constructor ctor) {
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static final class InterceptorClassDescriptionTraversal
    extends ClassDescriptionTraversal {
        private final EEModuleDescription moduleDescription;
        private final EJBComponentDescription ejbComponentDescription;
        private final DeploymentReflectionIndex deploymentReflectionIndex;
        private final Class<?> interceptorClass;
        private final List<InterceptorFactory> aroundInvokeInterceptorFactories = new ArrayList<InterceptorFactory>();
        private final List<InterceptorFactory> aroundTimeoutInterceptorFactories = new ArrayList<InterceptorFactory>();

        InterceptorClassDescriptionTraversal(Class<?> interceptorClass, EEApplicationClasses applicationClasses, DeploymentUnit deploymentUnit, EJBComponentDescription ejbComponentDescription) {
            super(interceptorClass, applicationClasses);
            this.ejbComponentDescription = ejbComponentDescription;
            this.deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
            this.moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            this.interceptorClass = interceptorClass;
        }

        public void handle(Class<?> clazz, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
            MethodIdentifier aroundTimeoutMethodIdentifier;
            InterceptorFactory aroundTimeoutInterceptorFactory;
            InterceptorClassDescription interceptorConfig = classDescription != null ? InterceptorClassDescription.merge((InterceptorClassDescription)classDescription.getInterceptorClassDescription(), (InterceptorClassDescription)this.moduleDescription.getInterceptorClassOverride(clazz.getName())) : InterceptorClassDescription.merge(null, (InterceptorClassDescription)this.moduleDescription.getInterceptorClassOverride(clazz.getName()));
            ClassReflectionIndex interceptorClassReflectionIndex = this.deploymentReflectionIndex.getClassIndex(this.interceptorClass);
            Constructor interceptorClassConstructor = interceptorClassReflectionIndex.getConstructor((Class[])EMPTY_CLASS_ARRAY);
            if (interceptorClassConstructor == null) {
                throw EeLogger.ROOT_LOGGER.defaultConstructorNotFound(this.interceptorClass);
            }
            MethodIdentifier aroundInvokeMethodIdentifier = interceptorConfig.getAroundInvoke();
            InterceptorFactory aroundInvokeInterceptorFactory = this.createInterceptorFactory(clazz, aroundInvokeMethodIdentifier, interceptorClassConstructor);
            if (aroundInvokeInterceptorFactory != null) {
                this.aroundInvokeInterceptorFactories.add(aroundInvokeInterceptorFactory);
            }
            if (this.ejbComponentDescription.isTimerServiceRequired() && (aroundTimeoutInterceptorFactory = this.createInterceptorFactory(clazz, aroundTimeoutMethodIdentifier = interceptorConfig.getAroundTimeout(), interceptorClassConstructor)) != null) {
                this.aroundTimeoutInterceptorFactories.add(aroundTimeoutInterceptorFactory);
            }
        }

        private InterceptorFactory createInterceptorFactory(Class<?> clazz, MethodIdentifier methodIdentifier, Constructor<?> interceptorClassConstructor) throws DeploymentUnitProcessingException {
            if (methodIdentifier == null) {
                return null;
            }
            Method method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)this.deploymentReflectionIndex, clazz, (MethodIdentifier)methodIdentifier);
            if (this.isNotOverriden(clazz, method, this.interceptorClass, this.deploymentReflectionIndex)) {
                return this.createInterceptorFactoryForContainerInterceptor(method, interceptorClassConstructor);
            }
            return null;
        }

        private boolean isNotOverriden(Class<?> clazz, Method method, Class<?> actualClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
            return Modifier.isPrivate(method.getModifiers()) || ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, actualClass, (Method)method).getDeclaringClass() == clazz;
        }

        private List<InterceptorFactory> getAroundInvokeInterceptorFactories() {
            return this.aroundInvokeInterceptorFactories;
        }

        private List<InterceptorFactory> getAroundTimeoutInterceptorFactories() {
            return this.aroundTimeoutInterceptorFactories;
        }

        private InterceptorFactory createInterceptorFactoryForContainerInterceptor(Method method, Constructor interceptorConstructor) {
            ValueManagedReference interceptorInstanceRef = new ValueManagedReference(EJBContainerInterceptorsViewConfigurator.newInstance(interceptorConstructor));
            return new ContainerInterceptorMethodInterceptorFactory((ManagedReference)interceptorInstanceRef, method);
        }
    }
}

