/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.security.IdentityEJBClientInterceptor;
import org.jboss.as.ejb3.security.IdentityInterceptor;
import org.jboss.as.ejb3.subsystem.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;

class IdentityInterceptorProcessor
implements DeploymentUnitProcessor {
    IdentityInterceptorProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        IdentityInterceptorProcessor.registerIdentityEJBClientInterceptor(deploymentUnit);
        IdentityInterceptorProcessor.registerIdentityInterceptor(deploymentUnit);
    }

    private static void registerIdentityEJBClientInterceptor(DeploymentUnit deploymentUnit) {
        ArrayList<IdentityEJBClientInterceptor> clientInterceptors = new ArrayList<IdentityEJBClientInterceptor>(Arrays.asList(IdentityEJBClientInterceptor.INSTANCE));
        deploymentUnit.putAttachment(Attachments.STATIC_EJB_CLIENT_INTERCEPTORS, clientInterceptors);
    }

    private static void registerIdentityInterceptor(DeploymentUnit deploymentUnit) {
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return;
        }
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        if (componentDescriptions == null || componentDescriptions.isEmpty()) {
            return;
        }
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof EJBComponentDescription)) continue;
            for (ViewDescription view : componentDescription.getViews()) {
                EJBViewDescription ejbView = (EJBViewDescription)view;
                ejbView.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        configuration.addClientInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new IdentityInterceptor()), 1);
                    }
                });
            }
        }
    }
}

