/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.value;

import java.util.StringTokenizer;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleValue;

public class IncrementValue
implements ScheduleValue {
    public static final String INCREMENT_SEPARATOR = "/";
    private final int start;
    private final int interval;

    public IncrementValue(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, INCREMENT_SEPARATOR);
        int numberOfTokens = tokenizer.countTokens();
        if (numberOfTokens != 2) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(ScheduleExpressionType.INCREMENT.name(), value);
        }
        String startVal = tokenizer.nextToken().trim();
        String intervalVal = tokenizer.nextToken().trim();
        try {
            this.start = "*".equals(startVal) ? 0 : Integer.parseInt(startVal);
            this.interval = Integer.parseInt(intervalVal);
        }
        catch (NumberFormatException e) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(ScheduleExpressionType.INCREMENT.name(), value);
        }
        if (this.interval < 1) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidScheduleValue(ScheduleExpressionType.INCREMENT.name(), value);
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getInterval() {
        return this.interval;
    }
}

