/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.wildfly.common.Assert;

public class OwnableReentrantLock {
    private static final long serialVersionUID = 493297473462848792L;
    private Object owner;
    private final Object lock = new Object();
    private int lockCount = 0;
    private int waiters = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object owner) {
        Assert.checkNotNullParam((String)"owner", (Object)owner);
        Object object = this.lock;
        synchronized (object) {
            if (Objects.equals(owner, this.owner)) {
                ++this.lockCount;
            } else if (this.owner == null) {
                this.owner = owner;
                ++this.lockCount;
            } else {
                while (this.owner != null) {
                    try {
                        ++this.waiters;
                        try {
                            this.lock.wait();
                        }
                        finally {
                            --this.waiters;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.owner = owner;
                ++this.lockCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long timeValue, TimeUnit timeUnit, Object owner) {
        Assert.checkNotNullParam((String)"owner", (Object)owner);
        Object object = this.lock;
        synchronized (object) {
            if (Objects.equals(owner, this.owner)) {
                ++this.lockCount;
                return true;
            }
            if (this.owner == null) {
                this.owner = owner;
                ++this.lockCount;
                return true;
            }
            long endTime = System.currentTimeMillis() + timeUnit.toMillis(timeValue);
            while (this.owner != null && System.currentTimeMillis() < endTime) {
                try {
                    ++this.waiters;
                    try {
                        this.lock.wait(endTime - System.currentTimeMillis());
                    }
                    finally {
                        --this.waiters;
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.owner == null) {
                this.owner = owner;
                ++this.lockCount;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object owner) {
        Assert.checkNotNullParam((String)"owner", (Object)owner);
        Object object = this.lock;
        synchronized (object) {
            if (!Objects.equals(owner, this.owner)) {
                throw new IllegalMonitorStateException();
            }
            if (--this.lockCount == 0) {
                this.owner = null;
                if (this.waiters > 0) {
                    this.lock.notifyAll();
                }
            }
        }
    }

    public String toString() {
        return super.toString() + (String)(this.owner == null ? "[Unlocked]" : "[Locked by " + this.owner + "]");
    }
}

