/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteUpdateHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;

public class CteMutationStrategy
implements SqmMultiTableMutationStrategy {
    public static final String SHORT_NAME = "cte";
    public static final String ID_TABLE_NAME = "id_cte";
    private final EntityPersister rootDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final CteTable idCteTable;

    public CteMutationStrategy(EntityMappingType rootEntityType, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityType.getEntityPersister(), runtimeModelCreationContext);
    }

    public CteMutationStrategy(EntityPersister rootDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.rootDescriptor = rootDescriptor;
        this.sessionFactory = runtimeModelCreationContext.getSessionFactory();
        Dialect dialect = runtimeModelCreationContext.getDialect();
        if (!dialect.supportsNonQueryWithCTE()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support CTE that can take UPDATE or DELETE statements as well");
        }
        if (!dialect.supportsValuesList()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support VALUES lists");
        }
        this.idCteTable = CteTable.createIdTable(ID_TABLE_NAME, rootDescriptor);
    }

    @Override
    public int executeDelete(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch(sqmDelete);
        return new CteDeleteHandler(this.idCteTable, sqmDelete, domainParameterXref, this, this.sessionFactory).execute(context);
    }

    @Override
    public int executeUpdate(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        this.checkMatch(sqmUpdate);
        return new CteUpdateHandler(this.idCteTable, sqmUpdate, domainParameterXref, this, this.sessionFactory).execute(context);
    }

    protected void checkMatch(SqmDeleteOrUpdateStatement<?> sqmStatement) {
        String targetEntityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister targetEntityDescriptor = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(targetEntityName);
        if (targetEntityDescriptor != this.rootDescriptor && !this.rootDescriptor.isSubclassEntityName(targetEntityDescriptor.getEntityName())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Target of query [%s] did not match configured entity [%s]", targetEntityName, this.rootDescriptor.getEntityName()));
        }
    }

    protected EntityPersister getRootDescriptor() {
        return this.rootDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected CteTable getIdCteTable() {
        return this.idCteTable;
    }
}

