/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.Locale;
import java.util.function.Function;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SqlExpressionResolver {
    public static ColumnReferenceKey createColumnReferenceKey(String tableExpression, String columnExpression) {
        return new ColumnReferenceKey(tableExpression, new SelectablePath(columnExpression));
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, String columnExpression) {
        return SqlExpressionResolver.createColumnReferenceKey(tableReference, new SelectablePath(columnExpression));
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, SelectablePath selectablePath) {
        if (!1.$assertionsDisabled && tableReference == null) {
            throw new AssertionError((Object)"tableReference expected to be non-null");
        }
        if (!1.$assertionsDisabled && selectablePath == null) {
            throw new AssertionError((Object)"selectablePath expected to be non-null");
        }
        if (!1.$assertionsDisabled && tableReference.getIdentificationVariable() == null) {
            throw new AssertionError((Object)"tableReference#identificationVariable expected to be non-null");
        }
        String qualifier = tableReference.getIdentificationVariable();
        return SqlExpressionResolver.createColumnReferenceKey(qualifier, selectablePath);
    }

    public static ColumnReferenceKey createColumnReferenceKey(String qualifier, SelectablePath selectablePath) {
        if (!1.$assertionsDisabled && qualifier == null) {
            throw new AssertionError((Object)"qualifier expected to be non-null");
        }
        if (!1.$assertionsDisabled && selectablePath == null) {
            throw new AssertionError((Object)"selectablePath expected to be non-null");
        }
        return new ColumnReferenceKey(qualifier, selectablePath);
    }

    public static ColumnReferenceKey createColumnReferenceKey(String columnExpression) {
        if (!1.$assertionsDisabled && columnExpression == null) {
            throw new AssertionError((Object)"columnExpression expected to be non-null");
        }
        return new ColumnReferenceKey("", new SelectablePath(columnExpression));
    }

    public static ColumnReferenceKey createColumnReferenceKey(String tableExpression, SelectableMapping selectable) {
        return SqlExpressionResolver.createColumnReferenceKey(tableExpression, selectable.getSelectablePath());
    }

    public static ColumnReferenceKey createColumnReferenceKey(TableReference tableReference, SelectableMapping selectable) {
        if (!1.$assertionsDisabled && !tableReference.containsAffectedTableName(selectable.getContainingTableExpression())) {
            throw new AssertionError((Object)String.format(Locale.ROOT, "Expecting tables to match between TableReference (%s) and SelectableMapping (%s)", tableReference.getTableId(), selectable.getContainingTableExpression()));
        }
        return SqlExpressionResolver.createColumnReferenceKey(tableReference, selectable.getSelectablePath());
    }

    default public Expression resolveSqlExpression(TableReference tableReference, SelectableMapping selectableMapping) {
        return this.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectableMapping), (SqlAstProcessingState processingState) -> new ColumnReference(tableReference, selectableMapping));
    }

    public Expression resolveSqlExpression(ColumnReferenceKey var1, Function<SqlAstProcessingState, Expression> var2);

    public SqlSelection resolveSqlSelection(Expression var1, JavaType<?> var2, FetchParent var3, TypeConfiguration var4);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class ColumnReferenceKey {
        private final String tableQualifier;
        private final SelectablePath selectablePath;

        public ColumnReferenceKey(String tableQualifier, SelectablePath selectablePath) {
            this.tableQualifier = tableQualifier;
            this.selectablePath = selectablePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnReferenceKey that = (ColumnReferenceKey)o;
            if (!this.tableQualifier.equals(that.tableQualifier)) {
                return false;
            }
            return this.selectablePath.equals(that.selectablePath);
        }

        public int hashCode() {
            int result = this.tableQualifier.hashCode();
            result = 31 * result + this.selectablePath.hashCode();
            return result;
        }
    }
}

