/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.AbstractMutationOperationGroup;

public class MutationOperationGroupStandard
extends AbstractMutationOperationGroup {
    private final List<MutationOperation> operations;

    public MutationOperationGroupStandard(MutationType mutationType, MutationTarget<?> mutationTarget, List<MutationOperation> operations) {
        super(mutationType, mutationTarget);
        this.operations = operations;
    }

    @Override
    public int getNumberOfOperations() {
        return this.operations.size();
    }

    @Override
    public <O extends MutationOperation> O getSingleOperation() {
        if (this.operations.size() == 1) {
            return (O)this.operations.get(0);
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Group contains multiple table mutations - %s : %s ", this.getMutationType().name(), this.getMutationTarget().getNavigableRole()));
    }

    @Override
    public <O extends MutationOperation> List<O> getOperations() {
        return this.operations;
    }

    @Override
    public <O extends MutationOperation> O getOperation(String tableName) {
        for (int i = 0; i < this.operations.size(); ++i) {
            MutationOperation operation = this.operations.get(i);
            if (!operation.getTableDetails().getTableName().equals(tableName)) continue;
            return (O)operation;
        }
        return null;
    }

    @Override
    public <O extends MutationOperation> void forEachOperation(BiConsumer<Integer, O> action) {
        for (int i = 0; i < this.operations.size(); ++i) {
            action.accept(i, this.operations.get(i));
        }
    }

    @Override
    public <O extends MutationOperation> boolean hasMatching(BiFunction<Integer, O, Boolean> matcher) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!matcher.apply(i, this.operations.get(i)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

