/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.Remove;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.AbstractType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.CompositeTypeImplementor;
import org.hibernate.usertype.CompositeUserType;

public class ComponentType
extends AbstractType
implements CompositeTypeImplementor,
ProcedureParameterExtractionAware {
    private final Class<?> componentClass;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyNullability;
    private final int[] originalPropertyOrder;
    protected final int propertySpan;
    private final CascadeStyle[] cascade;
    private final FetchMode[] joinedFetch;
    private final boolean isAggregate;
    private final boolean isKey;
    private boolean hasNotNullProperty;
    private final CompositeUserType<Object> compositeUserType;
    private EmbeddableValuedModelPart mappingModelPart;
    private Boolean canDoExtraction;

    public ComponentType(Component component, int[] originalPropertyOrder, MetadataBuildingContext buildingContext) {
        this.componentClass = component.isDynamic() ? Map.class : component.getComponentClass();
        this.isAggregate = component.getAggregateColumn() != null;
        this.isKey = component.isKey();
        this.propertySpan = component.getPropertySpan();
        this.originalPropertyOrder = originalPropertyOrder;
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.cascade = new CascadeStyle[this.propertySpan];
        this.joinedFetch = new FetchMode[this.propertySpan];
        int i = 0;
        for (Property property : component.getProperties()) {
            this.propertyNames[i] = property.getName();
            this.propertyTypes[i] = property.getValue().getType();
            this.propertyNullability[i] = property.isOptional();
            this.cascade[i] = property.getCascadeStyle();
            this.joinedFetch[i] = property.getValue().getFetchMode();
            if (!this.propertyNullability[i]) {
                this.hasNotNullProperty = true;
            }
            ++i;
        }
        if (component.getTypeName() != null) {
            ManagedBeanRegistry beanRegistry = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
            Class customTypeClass = buildingContext.getBootstrapContext().getClassLoaderAccess().classForName(component.getTypeName());
            this.compositeUserType = buildingContext.getBuildingOptions().disallowExtensionsInCdi() ? (CompositeUserType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(customTypeClass) : (CompositeUserType)beanRegistry.getBean(customTypeClass).getBeanInstance();
        } else {
            this.compositeUserType = null;
        }
    }

    private boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            span += this.propertyTypes[i].getColumnSpan(mapping);
        }
        return span;
    }

    @Override
    public int[] getSqlTypeCodes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int[] subtypes;
            for (int subtype : subtypes = this.propertyTypes[i].getSqlTypeCodes(mapping)) {
                sqlTypes[n++] = subtype;
            }
        }
        return sqlTypes;
    }

    @Override
    public final boolean isComponentType() {
        return true;
    }

    @Override
    public Class<?> getReturnedClass() {
        return this.componentClass;
    }

    @Override
    public boolean isSame(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        Object[] xvalues = this.getPropertyValues(x);
        Object[] yvalues = this.getPropertyValues(y);
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isSame(xvalues[i], yvalues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.equals(x, y);
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isEqual(this.getPropertyValue(x, i), this.getPropertyValue(y, i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.equals(x, y);
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].isEqual(this.getPropertyValue(x, i), this.getPropertyValue(y, i), factory)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(Object x, Object y) {
        if (x == y) {
            return 0;
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            int propertyCompare = this.propertyTypes[i].compare(this.getPropertyValue(x, i), this.getPropertyValue(y, i));
            if (propertyCompare == 0) continue;
            return propertyCompare;
        }
        return 0;
    }

    @Override
    public int compare(Object x, Object y, SessionFactoryImplementor sessionFactory) {
        if (x == y) {
            return 0;
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            int propertyCompare = this.propertyTypes[i].compare(this.getPropertyValue(x, i), this.getPropertyValue(y, i), sessionFactory);
            if (propertyCompare == 0) continue;
            return propertyCompare;
        }
        return 0;
    }

    @Override
    public boolean isMethodOf(Method method) {
        return false;
    }

    @Override
    public int getHashCode(Object x) {
        if (this.compositeUserType != null) {
            return this.compositeUserType.hashCode(x);
        }
        int result = 17;
        for (int i = 0; i < this.propertySpan; ++i) {
            Object y = this.getPropertyValue(x, i);
            result *= 37;
            if (y == null) continue;
            result += this.propertyTypes[i].getHashCode(y);
        }
        return result;
    }

    @Override
    public int getHashCode(Object x, SessionFactoryImplementor factory) {
        if (this.compositeUserType != null) {
            return this.compositeUserType.hashCode(x);
        }
        int result = 17;
        for (int i = 0; i < this.propertySpan; ++i) {
            Object y = this.getPropertyValue(x, i);
            result *= 37;
            if (y == null) continue;
            result += this.propertyTypes[i].getHashCode(y, factory);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object x, Object y, SharedSessionContractImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        for (int i = 0; i < this.propertySpan; ++i) {
            if (!this.propertyTypes[i].isDirty(this.getPropertyValue(x, i), this.getPropertyValue(y, i), session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty(Object x, Object y, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        int loc = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int len = this.propertyTypes[i].getColumnSpan(session.getFactory());
            if (len <= 1) {
                boolean dirty;
                boolean bl = dirty = (len == 0 || checkable[loc]) && this.propertyTypes[i].isDirty(this.getPropertyValue(x, i), this.getPropertyValue(y, i), session);
                if (dirty) {
                    return true;
                }
            } else {
                boolean[] subcheckable = new boolean[len];
                System.arraycopy(checkable, loc, subcheckable, 0, len);
                boolean dirty = this.propertyTypes[i].isDirty(this.getPropertyValue(x, i), this.getPropertyValue(y, i), subcheckable, session);
                if (dirty) {
                    return true;
                }
            }
            loc += len;
        }
        return false;
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (old == current) {
            return false;
        }
        int loc = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int len = this.propertyTypes[i].getColumnSpan(session.getFactory());
            boolean[] subcheckable = new boolean[len];
            System.arraycopy(checkable, loc, subcheckable, 0, len);
            if (this.propertyTypes[i].isModified(this.getPropertyValue(old, i), this.getPropertyValue(current, i), subcheckable, session)) {
                return true;
            }
            loc += len;
        }
        return false;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int begin, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        for (int i = 0; i < this.propertySpan; ++i) {
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.propertyTypes[i].getColumnSpan(session.getFactory());
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int begin, boolean[] settable, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        int loc = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int len = this.propertyTypes[i].getColumnSpan(session.getFactory());
            if (len != 0) {
                if (len == 1) {
                    if (settable[loc]) {
                        this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
                        ++begin;
                    }
                } else {
                    boolean[] subsettable = new boolean[len];
                    System.arraycopy(settable, loc, subsettable, 0, len);
                    this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, subsettable, session);
                    begin += ArrayHelper.countTrue(subsettable);
                }
            }
            loc += len;
        }
    }

    private Object[] nullSafeGetValues(Object value) {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    @Override
    public Object getPropertyValue(Object component, int i, SharedSessionContractImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) {
        if (component == null) {
            return null;
        }
        if (component instanceof Object[]) {
            return ((Object[])component)[i];
        }
        return this.mappingModelPart.getEmbeddableTypeDescriptor().getValue(component, i);
    }

    @Override
    public Object[] getPropertyValues(Object component, SharedSessionContractImplementor session) {
        return this.getPropertyValues(component);
    }

    @Override
    public Object[] getPropertyValues(Object component) {
        if (component == null) {
            return new Object[this.propertySpan];
        }
        if (component instanceof Object[]) {
            return (Object[])component;
        }
        return this.mappingModelPart.getEmbeddableTypeDescriptor().getValues(component);
    }

    @Override
    public void setPropertyValues(Object component, Object[] values) {
        this.mappingModelPart.getEmbeddableTypeDescriptor().setValues(component, values);
    }

    @Override
    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    @Deprecated(since="6.2")
    @Remove
    public Generator[] getPropertyValueGenerationStrategies() {
        return null;
    }

    @Override
    public String getName() {
        return "component" + ArrayHelper.toString(this.propertyNames);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Object[] values = this.getPropertyValues(value);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            if (values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                result.put(this.propertyNames[i], "<uninitialized>");
                continue;
            }
            result.put(this.propertyNames[i], this.propertyTypes[i].toLoggableString(values[i], factory));
        }
        return StringHelper.unqualify(this.getName()) + result;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object deepCopy(Object component, SessionFactoryImplementor factory) {
        if (component == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.deepCopy(component);
        }
        Object[] values = this.getPropertyValues(component);
        for (int i = 0; i < this.propertySpan; ++i) {
            values[i] = this.propertyTypes[i].deepCopy(values[i], factory);
        }
        EmbeddableInstantiator instantiator = this.mappingModelPart.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator();
        Object result = instantiator.instantiate(() -> values, factory);
        PropertyAccess parentAccess = this.mappingModelPart().getParentInjectionAttributePropertyAccess();
        if (parentAccess != null) {
            parentAccess.getSetter().set(result, parentAccess.getGetter().get(component));
        }
        return result;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        if (original == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.replace(original, target, owner);
        }
        Object[] originalValues = this.getPropertyValues(original);
        Object[] resultValues = target == null ? new Object[originalValues.length] : this.getPropertyValues(target);
        Object[] replacedValues = TypeHelper.replace(originalValues, resultValues, this.propertyTypes, session, owner, copyCache);
        if (target == null) {
            EmbeddableInstantiator instantiator = this.mappingModelPart.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator();
            return instantiator.instantiate(() -> replacedValues, session.getSessionFactory());
        }
        this.setPropertyValues(target, replacedValues);
        return target;
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        if (original == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.replace(original, target, owner);
        }
        Object[] originalValues = this.getPropertyValues(original);
        Object[] resultValues = target == null ? new Object[originalValues.length] : this.getPropertyValues(target);
        Object[] replacedValues = TypeHelper.replace(originalValues, resultValues, this.propertyTypes, session, owner, copyCache, foreignKeyDirection);
        if (target == null) {
            EmbeddableInstantiator instantiator = this.mappingModelPart.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator();
            return instantiator.instantiate(() -> replacedValues, session.getSessionFactory());
        }
        this.setPropertyValues(target, replacedValues);
        return target;
    }

    @Override
    public CascadeStyle getCascadeStyle(int i) {
        return this.cascade[i];
    }

    @Override
    public boolean isMutable() {
        return this.compositeUserType == null || this.compositeUserType.isMutable();
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.disassemble(value);
        }
        Object[] values = this.getPropertyValues(value);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            values[i] = this.propertyTypes[i].disassemble(values[i], session, owner);
        }
        return values;
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.disassemble(value);
        }
        Object[] values = this.getPropertyValues(value);
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            values[i] = this.propertyTypes[i].disassemble(values[i], sessionFactory);
        }
        return values;
    }

    @Override
    public Object assemble(Serializable object, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (object == null) {
            return null;
        }
        if (this.compositeUserType != null) {
            return this.compositeUserType.assemble(object, owner);
        }
        Object[] values = (Object[])object;
        Object[] assembled = new Object[values.length];
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            assembled[i] = this.propertyTypes[i].assemble((Serializable)values[i], session, owner);
        }
        EmbeddableInstantiator instantiator = this.mappingModelPart.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator();
        return instantiator.instantiate(() -> assembled, session.getFactory());
    }

    @Override
    public FetchMode getFetchMode(int i) {
        return this.joinedFetch[i];
    }

    @Override
    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value == null) {
            return result;
        }
        Object[] values = this.getPropertyValues(value);
        int loc = 0;
        for (int i = 0; i < this.propertyTypes.length; ++i) {
            boolean[] propertyNullness = this.propertyTypes[i].toColumnNullness(values[i], mapping);
            System.arraycopy(propertyNullness, 0, result, loc, propertyNullness.length);
            loc += propertyNullness.length;
        }
        return result;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public int getPropertyIndex(String name) {
        String[] names = this.getPropertyNames();
        int max = names.length;
        for (int i = 0; i < max; ++i) {
            if (!names[i].equals(name)) continue;
            return i;
        }
        throw new PropertyNotFoundException("Unable to locate property named " + name + " on " + this.getReturnedClass().getName());
    }

    public int[] getOriginalPropertyOrder() {
        return this.originalPropertyOrder;
    }

    @Override
    public boolean canDoExtraction() {
        if (this.canDoExtraction == null) {
            this.canDoExtraction = this.determineIfProcedureParamExtractionCanBePerformed();
        }
        return this.canDoExtraction;
    }

    @Override
    public JdbcType getJdbcType() {
        SelectableMapping aggregateMapping = this.mappingModelPart.getEmbeddableTypeDescriptor().getAggregateMapping();
        return aggregateMapping == null ? null : aggregateMapping.getJdbcMapping().getJdbcType();
    }

    private boolean determineIfProcedureParamExtractionCanBePerformed() {
        for (Type propertyType : this.propertyTypes) {
            if (!(propertyType instanceof ProcedureParameterExtractionAware)) {
                return false;
            }
            if (((ProcedureParameterExtractionAware)((Object)propertyType)).canDoExtraction()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        Object[] values;
        if (this.isAggregate()) {
            values = (Object[])this.getMappingModelPart().getEmbeddableTypeDescriptor().getAggregateMapping().getJdbcMapping().getJdbcValueExtractor().extract(statement, startIndex, (WrapperOptions)session);
        } else {
            values = new Object[this.propertySpan];
            int currentIndex = startIndex;
            boolean notNull = false;
            for (int i = 0; i < this.propertySpan; ++i) {
                Type propertyType = this.propertyTypes[i];
                Object value = ((ProcedureParameterExtractionAware)((Object)propertyType)).extract(statement, currentIndex, session);
                if (value == null) {
                    if (this.isKey) {
                        return null;
                    }
                } else {
                    notNull = true;
                }
                values[i] = value;
                currentIndex += propertyType.getColumnSpan(session.getFactory());
            }
            if (!notNull) {
                values = null;
            }
        }
        return this.resolve(values, session);
    }

    @Override
    public Object extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        assert (this.isAggregate());
        Object[] values = (Object[])this.getMappingModelPart().getEmbeddableTypeDescriptor().getAggregateMapping().getJdbcMapping().getJdbcValueExtractor().extract(statement, paramName, (WrapperOptions)session);
        return this.resolve(values, session);
    }

    private Object resolve(Object[] value, SharedSessionContractImplementor session) throws HibernateException {
        EmbeddableInstantiator instantiator = this.mappingModelPart.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator();
        return instantiator.instantiate(() -> value, session.getFactory());
    }

    @Override
    public boolean hasNotNullProperty() {
        return this.hasNotNullProperty;
    }

    @Override
    public Class<?> getBindableJavaType() {
        return this.getReturnedClass();
    }

    @Override
    public SqmExpressible<?> resolveExpressible(SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getRuntimeMetamodels().getJpaMetamodel().embeddable(this.getReturnedClass());
    }

    @Override
    public void injectMappingModelPart(EmbeddableValuedModelPart part, MappingModelCreationProcess process) {
        this.mappingModelPart = part;
    }

    @Override
    public EmbeddableValuedModelPart getMappingModelPart() {
        return this.mappingModelPart;
    }

    public EmbeddableValuedModelPart mappingModelPart() {
        if (this.mappingModelPart == null) {
            throw new IllegalStateException("Attempt to access EmbeddableValuedModelPart prior to its injection");
        }
        return this.mappingModelPart;
    }

    public boolean isCompositeUserType() {
        return this.compositeUserType != null;
    }
}

