/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetTimeJavaType
extends AbstractTemporalJavaType<OffsetTime> {
    public static final OffsetTimeJavaType INSTANCE = new OffsetTimeJavaType();

    public OffsetTimeJavaType() {
        super(OffsetTime.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIME;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators stdIndicators) {
        return stdIndicators.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(stdIndicators.getDefaultZonedTimeSqlType());
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(OffsetTime value) {
        return DateTimeFormatter.ISO_OFFSET_TIME.format(value);
    }

    @Override
    public OffsetTime fromString(CharSequence string) {
        return OffsetTime.from(DateTimeFormatter.ISO_OFFSET_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(OffsetTime offsetTime, Class<X> type, WrapperOptions options) {
        if (offsetTime == null) {
            return null;
        }
        if (OffsetTime.class.isAssignableFrom(type)) {
            return (X)offsetTime;
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            return (X)offsetTime.withOffsetSameInstant(OffsetTimeJavaType.getCurrentSystemOffset()).toLocalTime();
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)offsetTime.atDate(LocalDate.EPOCH);
        }
        OffsetTime jdbcOffsetTime = offsetTime.withOffsetSameInstant(OffsetTimeJavaType.getCurrentJdbcOffset(options));
        if (Time.class.isAssignableFrom(type)) {
            Time time = Time.valueOf(jdbcOffsetTime.toLocalTime());
            if (jdbcOffsetTime.getNano() == 0) {
                return (X)time;
            }
            return (X)new Time(time.getTime() + DateTimeUtils.roundToPrecision(jdbcOffsetTime.getNano(), 3));
        }
        OffsetDateTime jdbcOffsetDateTime = jdbcOffsetTime.atDate(LocalDate.EPOCH);
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(jdbcOffsetDateTime.toLocalDateTime());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(jdbcOffsetDateTime.toZonedDateTime());
        }
        Instant instant = offsetTime.atDate(LocalDate.EPOCH).toInstant();
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(instant);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atOffset(OffsetTimeJavaType.getCurrentSystemOffset());
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toOffsetTime();
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            OffsetTime offsetTime = time.toLocalTime().atOffset(OffsetTimeJavaType.getCurrentJdbcOffset(options)).withOffsetSameInstant(OffsetTimeJavaType.getCurrentSystemOffset());
            long millis = time.getTime() % 1000L;
            if (millis == 0L) {
                return offsetTime;
            }
            return offsetTime.with(ChronoField.NANO_OF_SECOND, millis * 1000000L);
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toLocalDateTime().toLocalTime().atOffset(OffsetTimeJavaType.getCurrentJdbcOffset(options)).withOffsetSameInstant(OffsetTimeJavaType.getCurrentSystemOffset());
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return OffsetTime.ofInstant(date.toInstant(), OffsetTimeJavaType.getCurrentSystemOffset());
        }
        if (value instanceof Long) {
            long millis = (Long)value;
            return OffsetTime.ofInstant(Instant.ofEpochMilli(millis), OffsetTimeJavaType.getCurrentSystemOffset());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    private static ZoneOffset getCurrentJdbcOffset(WrapperOptions options) {
        if (options.getJdbcTimeZone() != null) {
            return OffsetDateTime.now().atZoneSameInstant(options.getJdbcTimeZone().toZoneId()).getOffset();
        }
        return OffsetTimeJavaType.getCurrentSystemOffset();
    }

    private static ZoneOffset getCurrentSystemOffset() {
        return OffsetDateTime.now().getOffset();
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }
}

