/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPContentTypeSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreBytesMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMapMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreObjectMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreStreamMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreTextMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidContentTypeException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;

public final class AMQPMessageSupport {
    public static final int NON_PERSISTENT = 1;
    public static final int PERSISTENT = 2;
    public static final long MESSAGE_DEFAULT_TIME_TO_LIVE = 0L;
    public static final int MESSAGE_DEFAULT_PRIORITY = 4;
    public static SimpleString HDR_ORIGINAL_ADDRESS_ANNOTATION = SimpleString.toSimpleString((String)"x-opt-ORIG-ADDRESS");
    public static final String JMS_REPLY_TO_TYPE_MSG_ANNOTATION_SYMBOL_NAME = "x-opt-jms-reply-to";
    public static final String X_OPT_DELIVERY_TIME = "x-opt-delivery-time";
    public static final String X_OPT_DELIVERY_DELAY = "x-opt-delivery-delay";
    public static final Symbol JMS_MSG_TYPE = Symbol.getSymbol((String)"x-opt-jms-msg-type");
    @Deprecated
    public static final Symbol JMS_DELIVERY_TIME = Symbol.getSymbol((String)"x-opt-delivery-time");
    public static final Symbol SCHEDULED_DELIVERY_TIME = Symbol.getSymbol((String)"x-opt-delivery-time");
    public static final Symbol SCHEDULED_DELIVERY_DELAY = Symbol.getSymbol((String)"x-opt-delivery-delay");
    public static final Symbol ROUTING_TYPE = Symbol.getSymbol((String)"x-opt-routing-type");
    public static final byte JMS_MESSAGE = 0;
    public static final byte JMS_OBJECT_MESSAGE = 1;
    public static final byte JMS_MAP_MESSAGE = 2;
    public static final byte JMS_BYTES_MESSAGE = 3;
    public static final byte JMS_STREAM_MESSAGE = 4;
    public static final byte JMS_TEXT_MESSAGE = 5;
    public static final Symbol SERIALIZED_JAVA_OBJECT_CONTENT_TYPE = Symbol.getSymbol((String)"application/x-java-serialized-object");
    public static final String JMS_AMQP_PREFIX = "JMS_AMQP_";
    public static final int JMS_AMQP_PREFIX_LENGTH = "JMS_AMQP_".length();
    public static final String ORIGINAL_ENCODING = "ORIGINAL_ENCODING";
    public static final String NATIVE = "NATIVE";
    public static final String HEADER = "HEADER";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String FIRST_ACQUIRER = "FirstAcquirer";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String CONTENT_ENCODING = "ContentEncoding";
    public static final String REPLYTO_GROUP_ID = "ReplyToGroupID";
    public static final String DURABLE = "DURABLE";
    public static final String PRIORITY = "PRIORITY";
    public static final String DELIVERY_ANNOTATION_PREFIX = "DA_";
    public static final String MESSAGE_ANNOTATION_PREFIX = "MA_";
    public static final String FOOTER_PREFIX = "FT_";
    public static final String ENCODED_PREFIX = "ENCODED_";
    public static final String JMS_AMQP_HEADER = "JMS_AMQP_HEADER";
    public static final String JMS_AMQP_HEADER_DURABLE = "JMS_AMQP_HEADERDURABLE";
    public static final String JMS_AMQP_HEADER_PRIORITY = "JMS_AMQP_HEADERPRIORITY";
    public static final String JMS_AMQP_PROPERTIES = "JMS_AMQP_PROPERTIES";
    public static final String JMS_AMQP_NATIVE = "JMS_AMQP_NATIVE";
    public static final String JMS_AMQP_FIRST_ACQUIRER = "JMS_AMQP_FirstAcquirer";
    public static final String JMS_AMQP_CONTENT_TYPE = "JMS_AMQP_ContentType";
    public static final String JMS_AMQP_CONTENT_ENCODING = "JMS_AMQP_ContentEncoding";
    public static final String JMS_AMQP_REPLYTO_GROUP_ID = "JMS_AMQP_ReplyToGroupID";
    public static final String JMS_AMQP_DELIVERY_ANNOTATION_PREFIX = "JMS_AMQP_DA_";
    public static final String JMS_AMQP_MESSAGE_ANNOTATION_PREFIX = "JMS_AMQP_MA_";
    public static final String JMS_AMQP_FOOTER_PREFIX = "JMS_AMQP_FT_";
    public static final String JMS_AMQP_ENCODED_DELIVERY_ANNOTATION_PREFIX = "JMS_AMQP_ENCODED_DA_";
    public static final String JMS_AMQP_ENCODED_MESSAGE_ANNOTATION_PREFIX = "JMS_AMQP_ENCODED_MA_";
    public static final String JMS_AMQP_ENCODED_FOOTER_PREFIX = "JMS_AMQP_ENCODED_FT_";
    public static final String JMS_AMQP_ORIGINAL_ENCODING = "JMS_AMQP_ORIGINAL_ENCODING";
    public static final Binary EMPTY_BINARY = new Binary(new byte[0]);
    public static final Data EMPTY_BODY = new Data(EMPTY_BINARY);
    public static final String X_OPT_PREFIX = "x-opt-";
    public static final String AMQ_PROPERTY_PREFIX = "_AMQ_";
    public static final String X_OPT_INGRESS_TIME = "x-opt-ingress-time";
    public static final short AMQP_UNKNOWN = 0;
    public static final short AMQP_NULL = 1;
    public static final short AMQP_DATA = 2;
    public static final short AMQP_SEQUENCE = 3;
    public static final short AMQP_VALUE_NULL = 4;
    public static final short AMQP_VALUE_STRING = 5;
    public static final short AMQP_VALUE_BINARY = 6;
    public static final short AMQP_VALUE_MAP = 7;
    public static final short AMQP_VALUE_LIST = 8;
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = AMQPMessageSupport.getSymbol("x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = AMQPMessageSupport.getSymbol("x-opt-jms-reply-to");
    public static final Symbol INGRESS_TIME_MSG_ANNOTATION = AMQPMessageSupport.getSymbol("x-opt-ingress-time");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    public static final Symbol OCTET_STREAM_CONTENT_TYPE_SYMBOL = Symbol.valueOf((String)"application/octet-stream");

    public static Symbol getSymbol(String key) {
        return Symbol.valueOf((String)key);
    }

    public static Object getMessageAnnotation(String key, Message message) {
        if (message != null && message.getMessageAnnotations() != null) {
            Map annotations = message.getMessageAnnotations().getValue();
            return annotations.get(AMQPMessageSupport.getSymbol(key));
        }
        return null;
    }

    public static boolean isContentType(String contentType, Message message) {
        if (contentType == null) {
            return message.getContentType() == null;
        }
        return contentType.equals(message.getContentType());
    }

    public static boolean isContentType(String expected, Symbol actual) {
        if (expected == null) {
            return actual == null;
        }
        return expected.equals(actual != null ? actual.toString() : actual);
    }

    public static Charset getCharsetForTextualContent(String contentType) {
        try {
            return AMQPContentTypeSupport.parseContentTypeForTextualCharset(contentType);
        }
        catch (ActiveMQAMQPInvalidContentTypeException e) {
            return null;
        }
    }

    public static String toAnnotationName(String key) {
        if (!key.startsWith(X_OPT_PREFIX.toString())) {
            if (key.startsWith(AMQ_PROPERTY_PREFIX)) {
                return X_OPT_PREFIX.concat(key.substring(AMQ_PROPERTY_PREFIX.length()).replace('_', '-'));
            }
            return key;
        }
        return key;
    }

    public static CoreBytesMessageWrapper createBytesMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreBytesMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)4, coreMessageObjectPools));
    }

    public static CoreBytesMessageWrapper createBytesMessage(long id, byte[] array, int arrayOffset, int length, CoreMessageObjectPools coreMessageObjectPools) {
        CoreBytesMessageWrapper message = AMQPMessageSupport.createBytesMessage(id, coreMessageObjectPools);
        message.writeBytes(array, arrayOffset, length);
        return message;
    }

    public static CoreStreamMessageWrapper createStreamMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreStreamMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)6, coreMessageObjectPools));
    }

    public static CoreMessageWrapper createMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)0, coreMessageObjectPools));
    }

    public static CoreTextMessageWrapper createTextMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreTextMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)3, coreMessageObjectPools));
    }

    public static CoreTextMessageWrapper createTextMessage(long id, String text, CoreMessageObjectPools coreMessageObjectPools) {
        CoreTextMessageWrapper message = AMQPMessageSupport.createTextMessage(id, coreMessageObjectPools);
        message.setText(text);
        return message;
    }

    public static CoreObjectMessageWrapper createObjectMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreObjectMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)2, coreMessageObjectPools));
    }

    public static CoreMessageWrapper createObjectMessage(long id, Binary serializedForm, CoreMessageObjectPools coreMessageObjectPools) {
        CoreObjectMessageWrapper message = AMQPMessageSupport.createObjectMessage(id, coreMessageObjectPools);
        message.setSerializedForm(serializedForm);
        return message;
    }

    public static CoreMessageWrapper createObjectMessage(long id, byte[] array, int offset, int length, CoreMessageObjectPools coreMessageObjectPools) {
        CoreObjectMessageWrapper message = AMQPMessageSupport.createObjectMessage(id, coreMessageObjectPools);
        message.setSerializedForm(new Binary(array, offset, length));
        return message;
    }

    public static CoreMapMessageWrapper createMapMessage(long id, CoreMessageObjectPools coreMessageObjectPools) {
        return new CoreMapMessageWrapper((ICoreMessage)AMQPMessageSupport.newMessage(id, (byte)5, coreMessageObjectPools));
    }

    public static CoreMapMessageWrapper createMapMessage(long id, Map<String, Object> content, CoreMessageObjectPools coreMessageObjectPools) {
        CoreMapMessageWrapper message = AMQPMessageSupport.createMapMessage(id, coreMessageObjectPools);
        Set<Map.Entry<String, Object>> set = content.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }

    private static CoreMessage newMessage(long id, byte messageType, CoreMessageObjectPools coreMessageObjectPools) {
        CoreMessage message = new CoreMessage(id, 512, coreMessageObjectPools);
        message.setType(messageType);
        return message;
    }

    public static String toAddress(String destination) {
        if (destination.startsWith("queue://")) {
            return destination.substring("queue://".length());
        }
        if (destination.startsWith("topic://")) {
            return destination.substring("topic://".length());
        }
        if (destination.startsWith("temp-queue://")) {
            return destination.substring("temp-queue://".length());
        }
        if (destination.startsWith("temp-topic://")) {
            return destination.substring("temp-topic://".length());
        }
        return destination;
    }

    public static byte destinationType(String destination) {
        if (destination.startsWith("queue://")) {
            return 0;
        }
        if (destination.startsWith("topic://")) {
            return 1;
        }
        if (destination.startsWith("temp-queue://")) {
            return 2;
        }
        if (destination.startsWith("temp-topic://")) {
            return 3;
        }
        return 0;
    }

    public static String destination(RoutingType destinationType, String address) {
        String prefix;
        if (destinationType == null) {
            destinationType = RoutingType.ANYCAST;
        }
        switch (destinationType) {
            case ANYCAST: {
                prefix = "queue://";
                break;
            }
            case MULTICAST: {
                prefix = "topic://";
                break;
            }
            default: {
                prefix = "queue://";
            }
        }
        if (!address.startsWith(prefix)) {
            return prefix + address;
        }
        return address;
    }
}

