/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public class CoreObjectMessageWrapper
extends CoreMessageWrapper {
    public static final byte TYPE = 2;
    private Binary payload;

    private static Binary getBinaryFromMessageBody(CoreObjectMessageWrapper message) {
        return message.getSerializedForm();
    }

    @Override
    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) throws ConversionException {
        properties.setContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE);
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)1);
        Binary payload = CoreObjectMessageWrapper.getBinaryFromMessageBody(this);
        if (payload == null) {
            payload = AMQPMessageSupport.EMPTY_BINARY;
        }
        if (!this.propertyExists("JMS_AMQP_ContentType")) {
            this.setStringProperty("JMS_AMQP_ContentType", AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString());
        }
        switch (this.getOrignalEncoding()) {
            case 6: {
                return new AmqpValue((Object)payload);
            }
        }
        return new Data(payload);
    }

    public CoreObjectMessageWrapper(ICoreMessage message) {
        super(message);
    }

    public void setSerializedForm(Binary payload) {
        this.payload = payload;
    }

    public Binary getSerializedForm() {
        return this.payload;
    }

    @Override
    public void encode() {
        super.encode();
        this.getInnerMessage().getBodyBuffer().writeInt(this.payload.getLength());
        this.getInnerMessage().getBodyBuffer().writeBytes(this.payload.getArray(), this.payload.getArrayOffset(), this.payload.getLength());
    }

    @Override
    public void decode() {
        super.decode();
        ActiveMQBuffer buffer = this.getInnerMessage().getDataBuffer();
        int size = buffer.readInt();
        byte[] bytes = new byte[size];
        buffer.readBytes(bytes);
        this.payload = new Binary(bytes);
    }
}

