/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.servlet.RequestData;

public class HttpServletRequestDelegator
extends HttpServletRequestWrapper {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String[] datePatterns = new String[]{"EE, dd MMM yyyy HH:mm:ss zz", "EEEE, dd-MMM-yy HH:mm:ss zz", "EE MMM  d HH:mm:ss yyyy"};
    private final RequestData requestData;
    private List<DateFormat> dateFormats;

    public HttpServletRequestDelegator(HttpServletRequest request, RequestData requestData) {
        super(request);
        this.requestData = requestData;
    }

    public Cookie[] getCookies() {
        return this.requestData.getCookies();
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.requestData.getHeaders().keySet());
    }

    public String getHeader(String name) {
        for (Map.Entry<String, List<String>> header : this.requestData.getHeaders().entrySet()) {
            if (!header.getKey().equalsIgnoreCase(name) || header.getValue().isEmpty()) continue;
            return header.getValue().get(0);
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList headers = new ArrayList();
        for (Map.Entry<String, List<String>> header : this.requestData.getHeaders().entrySet()) {
            if (!header.getKey().equalsIgnoreCase(name)) continue;
            headers.addAll(header.getValue());
        }
        return Collections.enumeration(headers);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        if (this.dateFormats == null) {
            this.dateFormats = new ArrayList<DateFormat>(datePatterns.length);
            for (String datePattern : datePatterns) {
                this.dateFormats.add(this.createDateFormat(datePattern));
            }
        }
        for (DateFormat dateFormat : this.dateFormats) {
            try {
                return dateFormat.parse(header).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException("Can't convert " + header + " to a date");
    }

    public Map<String, String[]> getParameterMap() {
        return this.requestData.getParameters();
    }

    public String getParameter(String name) {
        Object[] values = this.requestData.getParameters().get(name);
        if (Utils.isEmpty(values)) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.requestData.getLocales());
    }

    public Locale getLocale() {
        if (this.requestData.getLocales().isEmpty()) {
            return Locale.getDefault();
        }
        return this.requestData.getLocales().get(0);
    }

    public String getMethod() {
        return this.requestData.getMethod();
    }

    private DateFormat createDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.US);
        dateFormat.setTimeZone(GMT);
        return dateFormat;
    }
}

