/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.resources.impl;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.AssertionFailure;

public class BackendThreads {
    private static final OptionalConfigurationProperty<Integer> THREAD_POOL_SIZE = ConfigurationProperty.forKey((String)"thread_pool.size").asIntegerStrictlyPositive().build();
    private final String prefix;
    private ThreadPoolProvider threadPoolProvider;
    private ScheduledExecutorService workExecutor;

    public BackendThreads(String prefix) {
        this.prefix = prefix;
    }

    public void onStart(ConfigurationPropertySource propertySource, ThreadPoolProvider threadPoolProvider) {
        if (this.workExecutor != null) {
            return;
        }
        this.threadPoolProvider = threadPoolProvider;
        int threadPoolSize = ((Optional)THREAD_POOL_SIZE.get(propertySource)).orElse(Runtime.getRuntime().availableProcessors());
        this.workExecutor = threadPoolProvider.newScheduledExecutor(threadPoolSize, this.prefix + " - Worker thread");
    }

    public void onStop() {
        if (this.workExecutor != null) {
            this.workExecutor.shutdownNow();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ThreadProvider getThreadProvider() {
        this.checkStarted();
        return this.threadPoolProvider.threadProvider();
    }

    public ScheduledExecutorService getWorkExecutor() {
        this.checkStarted();
        return this.workExecutor;
    }

    private void checkStarted() {
        if (this.workExecutor == null) {
            throw new AssertionFailure("Attempt to retrieve the executor or related information before the backend was started.");
        }
    }
}

