/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchBooleanPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchAllPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchMatchIdPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSimpleQueryStringPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchUserProvidedJsonPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;

public class ElasticsearchSearchPredicateBuilderFactory
implements SearchPredicateBuilderFactory {
    private final ElasticsearchSearchIndexScope<?> scope;

    public ElasticsearchSearchPredicateBuilderFactory(ElasticsearchSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public MatchAllPredicateBuilder matchAll() {
        return new ElasticsearchMatchAllPredicate.Builder(this.scope);
    }

    public MatchIdPredicateBuilder id() {
        return new ElasticsearchMatchIdPredicate.Builder(this.scope);
    }

    public BooleanPredicateBuilder bool() {
        return new ElasticsearchBooleanPredicate.Builder(this.scope);
    }

    public SimpleQueryStringPredicateBuilder simpleQueryString() {
        return new ElasticsearchSimpleQueryStringPredicate.Builder(this.scope);
    }

    public ElasticsearchSearchPredicate fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonPredicate(this.scope, jsonObject);
    }

    public ElasticsearchSearchPredicate fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.scope.userFacingGson().fromJson(jsonString, JsonObject.class));
    }
}

