/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NullAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class TransferQueueBundler2
implements Bundler,
Runnable {
    @Property(name="max_size", type=AttributeType.BYTES, description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_size = 64000;
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations", type=AttributeType.SCALAR)
    protected int capacity = 16384;
    @Property(description="Time (microseconds) to wait on poll() from the down_queue. A value of <= 0 doesn't wait", type=AttributeType.TIME, unit=TimeUnit.MICROSECONDS)
    protected long poll_timeout = 50L;
    protected TP transport;
    protected Log log;
    protected BlockingQueue<Message> queue;
    protected List<Message> remove_queue;
    protected volatile Thread bundler_thread;
    protected volatile boolean running = true;
    @ManagedAttribute(description="Number of times a message was sent because the queue was full", type=AttributeType.SCALAR)
    protected long num_sends_because_full_queue;
    @ManagedAttribute(description="Number of times a message was sent because there was no message available", type=AttributeType.SCALAR)
    protected long num_sends_because_no_msgs;
    @ManagedAttribute(description="Average fill size of the queue (in bytes)")
    protected final AverageMinMax avg_fill_count = new AverageMinMax();
    protected static final String THREAD_NAME = "TQ-Bundler2";
    protected final Map<Address, Buffer> messages = new ConcurrentHashMap<Address, Buffer>();
    protected static final NullAddress NIL = new NullAddress();

    public TransferQueueBundler2() {
        this.remove_queue = new ArrayList<Message>(16);
    }

    protected TransferQueueBundler2(BlockingQueue<Message> queue) {
        this.queue = queue;
        this.remove_queue = new ArrayList<Message>(16);
    }

    public TransferQueueBundler2(int capacity) {
        this(new ArrayBlockingQueue<Message>(TransferQueueBundler2.assertPositive(capacity, "bundler capacity cannot be " + capacity)));
    }

    public Thread getThread() {
        return this.bundler_thread;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public Bundler setCapacity(int c) {
        this.capacity = c;
        return this;
    }

    @Override
    public int getMaxSize() {
        return this.max_size;
    }

    @Override
    public Bundler setMaxSize(int s) {
        this.max_size = s;
        return this;
    }

    @Override
    @ManagedAttribute(description="Size of the queue")
    public int getQueueSize() {
        return this.queue.size();
    }

    @ManagedAttribute(description="Size of the remove-queue")
    public int removeQueueSize() {
        return this.remove_queue.size();
    }

    public TransferQueueBundler2 removeQueueSize(int size) {
        this.remove_queue = new ArrayList<Message>(size);
        return this;
    }

    @ManagedOperation(description="dumps info about buffers")
    public String dump() {
        return this.messages.entrySet().stream().map(e -> String.format("%s: %s", e.getKey() instanceof NullAddress ? "null" : e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.messages.putIfAbsent(NIL, new Buffer(this.max_size + 5));
    }

    @Override
    public void resetStats() {
        this.num_sends_because_full_queue = 0L;
        this.num_sends_because_no_msgs = 0L;
        this.avg_fill_count.clear();
    }

    @Override
    public void viewChange(View view) {
        this.messages.keySet().retainAll(view.getMembers());
        this.messages.putIfAbsent(NIL, new Buffer(this.max_size + 5));
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.stop();
        }
        this.queue = new ArrayBlockingQueue<Message>(TransferQueueBundler2.assertPositive(this.capacity, "bundler capacity cannot be " + this.capacity));
        this.bundler_thread = this.transport.getThreadFactory().newThread(this, THREAD_NAME);
        this.running = true;
        this.bundler_thread.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        Thread tmp = this.bundler_thread;
        this.bundler_thread = null;
        if (tmp != null) {
            tmp.interrupt();
            if (tmp.isAlive()) {
                try {
                    tmp.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.drain();
    }

    @Override
    public int size() {
        return this.removeQueueSize() + this.getQueueSize();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (this.running) {
            this.queue.put(msg);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            Message msg = null;
            try {
                msg = this.queue.take();
                if (msg == null) continue;
                this.addAndSendIfSizeExceeded(msg);
                block3: while (true) {
                    this.remove_queue.clear();
                    int num_msgs = this.queue.drainTo(this.remove_queue);
                    if (num_msgs > 0) {
                        Iterator<Message> iterator = this.remove_queue.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            Message m = iterator.next();
                            this.addAndSendIfSizeExceeded(m);
                        }
                    }
                    msg = this.queue.poll(this.poll_timeout, TimeUnit.MICROSECONDS);
                    if (msg == null) break;
                    this.addAndSendIfSizeExceeded(msg);
                }
                if (!this.hasMessages()) continue;
                ++this.num_sends_because_no_msgs;
                this.sendBundledMessages();
            }
            catch (Throwable throwable) {}
        }
    }

    protected boolean hasMessages() {
        return this.messages.values().stream().anyMatch(b -> !b.isEmpty());
    }

    protected void addAndSendIfSizeExceeded(Message msg) {
        int size = msg.size();
        Address dest = msg.getDest() == null ? NIL : msg.getDest();
        Buffer buf = this.messages.computeIfAbsent(dest, d -> new Buffer(size + 5));
        if (buf.out.position() + size > this.max_size) {
            ++this.num_sends_because_full_queue;
            this.avg_fill_count.add(buf.out.position());
            try {
                buf.send(msg.dest(), this.transport);
            }
            catch (Exception ex) {
                this.log.error("%s: failed sending message: %s", this.transport.getAddress(), ex);
            }
        }
        try {
            buf.addMessage(msg, this.transport);
        }
        catch (Exception ex) {
            this.log.error("%s: failed serializing message to buffer: %s", this.transport.getAddress(), ex);
            buf.reset();
        }
    }

    protected void sendBundledMessages() {
        for (Map.Entry<Address, Buffer> entry : this.messages.entrySet()) {
            Buffer buf = entry.getValue();
            if (buf.isEmpty()) continue;
            Address dest = entry.getKey();
            try {
                this.avg_fill_count.add(buf.out.position());
                buf.send(dest instanceof NullAddress || dest == null ? null : dest, this.transport);
            }
            catch (Exception ex) {
                this.log.trace("%s: failed sending message: %s", this.transport.getAddress(), ex);
            }
        }
    }

    protected void drain() {
        if (this.queue != null) {
            Message msg;
            while ((msg = (Message)this.queue.poll()) != null) {
                this.addAndSendIfSizeExceeded(msg);
            }
        }
        this.sendBundledMessages();
    }

    protected static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    private static class Buffer {
        private final ByteArrayDataOutputStream out;
        private int length_index;
        private int count;

        private Buffer(int length) {
            this.out = new ByteArrayDataOutputStream(length);
        }

        private Buffer reset() {
            this.out.position(0);
            this.count = 0;
            this.length_index = 0;
            return this;
        }

        private int size() {
            return this.out.position();
        }

        private boolean isEmpty() {
            return this.size() == 0;
        }

        private Buffer correctLength() {
            int old_pos = this.out.position();
            this.out.position(this.length_index).writeInt(this.count);
            this.out.position(old_pos);
            return this;
        }

        private Buffer addMessage(Message msg, TP transport) throws IOException {
            short transport_id = transport.getId();
            if (this.count == 0) {
                Util.writeMessageListHeader(msg.dest(), transport.getAddress(), transport.getClusterNameAscii().chars(), 1, this.out, msg.getDest() == null);
                this.length_index = this.out.position() - 4;
            }
            this.out.writeShort(msg.getType());
            msg.writeToNoAddrs(msg.src(), this.out, transport_id);
            ++this.count;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Buffer send(Address dest, TP transport) throws Exception {
            try {
                if (this.count > 0) {
                    if (this.count > 1) {
                        this.correctLength();
                    }
                    transport.doSend(this.out.buffer(), 0, this.out.position(), dest);
                }
                Buffer buffer = this;
                return buffer;
            }
            finally {
                this.reset();
            }
        }

        public String toString() {
            return String.format("%d msg(s) %d bytes [cpacity=%d bytes]", this.count, this.out.position(), this.out.capacity());
        }
    }
}

