/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.modules.ModuleIdentifier;

public class JSFModuleIdFactory {
    private static final String API_MODULE = "jakarta.faces.api";
    private static final String IMPL_MODULE = "com.sun.jsf-impl";
    private static final String INJECTION_MODULE = "org.jboss.as.jsf-injection";
    private static final JSFModuleIdFactory instance = new JSFModuleIdFactory();
    private String defaultSlot = "main";
    private Map<String, ModuleIdentifier> apiIds = new HashMap<String, ModuleIdentifier>();
    private Map<String, ModuleIdentifier> implIds = new HashMap<String, ModuleIdentifier>();
    private Map<String, ModuleIdentifier> injectionIds = new HashMap<String, ModuleIdentifier>();
    private Set<String> allVersions = new HashSet<String>();
    private List<String> activeVersions = new ArrayList<String>();

    public static JSFModuleIdFactory getInstance() {
        return instance;
    }

    private JSFModuleIdFactory() {
        String modulePath = System.getProperty("module.path", System.getenv("JAVA_MODULEPATH"));
        if (!this.isBogusPath(modulePath)) {
            this.loadIdsFromModulePath(modulePath);
        }
        if (!this.activeVersions.contains("main")) {
            this.loadIdsManually();
        }
        JSFLogger.ROOT_LOGGER.activatedJSFImplementations(this.activeVersions);
    }

    void setDefaultSlot(String defaultSlot) {
        this.defaultSlot = defaultSlot;
    }

    String getDefaultSlot() {
        return this.defaultSlot;
    }

    private boolean isBogusPath(String path) {
        if (path == null) {
            return true;
        }
        for (String dir : path.split(File.pathSeparator)) {
            if (!new File(dir).exists()) continue;
            return false;
        }
        return true;
    }

    private void loadIdsManually() {
        this.implIds.put("main", ModuleIdentifier.create((String)IMPL_MODULE));
        this.apiIds.put("main", ModuleIdentifier.create((String)API_MODULE));
        this.injectionIds.put("main", ModuleIdentifier.create((String)INJECTION_MODULE));
        this.allVersions.add("main");
        this.activeVersions.add("main");
    }

    private void loadIdsFromModulePath(String modulePath) {
        for (String moduleRootDir : modulePath.split(File.pathSeparator)) {
            this.loadIds(moduleRootDir, this.apiIds, API_MODULE);
            this.loadIds(moduleRootDir, this.implIds, IMPL_MODULE);
            this.loadIds(moduleRootDir, this.injectionIds, INJECTION_MODULE);
        }
        this.checkVersionIntegrity();
    }

    private void loadIds(String moduleRootDir, Map<String, ModuleIdentifier> idMap, String moduleName) {
        StringBuilder baseDirBuilder = new StringBuilder(moduleRootDir);
        baseDirBuilder.append(File.separator);
        baseDirBuilder.append(moduleName.replace(".", File.separator));
        File moduleBaseDir = new File(baseDirBuilder.toString());
        File[] slots = moduleBaseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (slots == null) {
            return;
        }
        for (File slot : slots) {
            if (!new File(slot, "module.xml").exists()) continue;
            String slotName = slot.getName();
            this.allVersions.add(slotName);
            idMap.put(slotName, ModuleIdentifier.create((String)moduleName, (String)slotName));
        }
    }

    private void checkVersionIntegrity() {
        this.activeVersions.addAll(this.allVersions);
        for (String version : this.allVersions) {
            if (!this.apiIds.containsKey(version)) {
                JSFLogger.ROOT_LOGGER.missingJSFModule(version, API_MODULE);
                this.activeVersions.remove(version);
            }
            if (!this.implIds.containsKey(version)) {
                JSFLogger.ROOT_LOGGER.missingJSFModule(version, IMPL_MODULE);
                this.activeVersions.remove(version);
            }
            if (this.injectionIds.containsKey(version)) continue;
            JSFLogger.ROOT_LOGGER.missingJSFModule(version, INJECTION_MODULE);
            this.activeVersions.remove(version);
        }
    }

    String computeSlot(String jsfVersion) {
        if (jsfVersion == null) {
            return this.defaultSlot;
        }
        if ("Mojarra-2.0".equals(jsfVersion)) {
            return this.defaultSlot;
        }
        return jsfVersion;
    }

    ModuleIdentifier getApiModId(String jsfVersion) {
        return this.apiIds.get(this.computeSlot(jsfVersion));
    }

    ModuleIdentifier getImplModId(String jsfVersion) {
        return this.implIds.get(this.computeSlot(jsfVersion));
    }

    ModuleIdentifier getInjectionModId(String jsfVersion) {
        return this.injectionIds.get(this.computeSlot(jsfVersion));
    }

    boolean isValidJSFSlot(String slot) {
        String computedSlot = this.computeSlot(slot);
        return this.apiIds.containsKey(computedSlot) && this.implIds.containsKey(computedSlot) && this.injectionIds.containsKey(computedSlot);
    }

    public List<String> getActiveJSFVersions() {
        return Collections.unmodifiableList(this.activeVersions);
    }
}

