/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import io.netty.util.collection.IntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.ConsumedPage;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.jboss.logging.Logger;

public final class PageSubscriptionImpl
implements PageSubscription {
    private static final Logger logger = Logger.getLogger(PageSubscriptionImpl.class);
    private static final Object DUMMY = new Object();
    private static final PagedReference RETRY_MARK = new PagedReferenceImpl(null, null);
    private boolean empty = true;
    private final AtomicInteger scheduledCleanupCount = new AtomicInteger(0);
    private volatile boolean autoCleanup = true;
    private final StorageManager store;
    private final long cursorId;
    private Queue queue;
    private final boolean persistent;
    private final Filter filter;
    private final PagingStore pageStore;
    private final PageCursorProvider cursorProvider;
    private volatile PagePosition lastAckedPosition;
    private List<PagePosition> recoveredACK;
    private final SortedMap<Long, PageCursorInfo> consumedPages = new TreeMap<Long, PageCursorInfo>();
    private final PageSubscriptionCounter counter;
    private final AtomicLong deliveredCount = new AtomicLong(0L);
    private final AtomicLong deliveredSize = new AtomicLong(0L);
    private boolean pageScanNeeded = true;
    private final java.util.LinkedList<PageScan> scanList = new java.util.LinkedList();

    public AtomicInteger getScheduledCleanupCount() {
        return this.scheduledCleanupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanAck(BooleanSupplier retryBeforeScan, ToIntFunction<PagedReference> scanFunction, Runnable found, Runnable notFound) {
        boolean pageScanNeededLocal;
        PageScan scan = new PageScan(retryBeforeScan, scanFunction, found, notFound);
        java.util.LinkedList<PageScan> linkedList = this.scanList;
        synchronized (linkedList) {
            this.scanList.add(scan);
            pageScanNeededLocal = this.pageScanNeeded;
            this.pageScanNeeded = false;
        }
        if (pageScanNeededLocal) {
            this.pageStore.execute(this::performScanAck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performScanAck() {
        try {
            PageScan scanElemen;
            int i;
            PageScan[] localScanList;
            java.util.LinkedList<PageScan> linkedList = this.scanList;
            synchronized (linkedList) {
                this.pageScanNeeded = true;
                if (this.scanList.size() == 0) {
                    return;
                }
                localScanList = (PageScan[])this.scanList.stream().toArray(PageScan[]::new);
                this.scanList.clear();
            }
            int retriedFound = 0;
            for (i = 0; i < localScanList.length; ++i) {
                scanElemen = localScanList[i];
                if (scanElemen.retryBeforeScan == null || !scanElemen.retryBeforeScan.getAsBoolean()) continue;
                localScanList[i] = null;
                ++retriedFound;
            }
            if (retriedFound == localScanList.length) {
                return;
            }
            if (!this.isPaging()) {
                for (i = 0; i < localScanList.length; ++i) {
                    scanElemen = localScanList[i];
                    if (scanElemen == null || scanElemen.notFound == null) continue;
                    scanElemen.notFound.run();
                }
                return;
            }
            final java.util.LinkedList<Runnable> afterCommitList = new java.util.LinkedList<Runnable>();
            TransactionImpl tx = new TransactionImpl(this.store);
            tx.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterCommit(Transaction tx) {
                    for (Runnable r : afterCommitList) {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            logger.warn((Object)e.getMessage(), e);
                        }
                    }
                }
            });
            try (PageIterator iterator = this.iterator(true);){
                while (iterator.hasNext()) {
                    PagedReference reference = (PagedReference)iterator.next();
                    boolean keepMoving = false;
                    for (int i2 = 0; i2 < localScanList.length; ++i2) {
                        PageScan scanElemen2 = localScanList[i2];
                        if (scanElemen2 == null) continue;
                        int result = scanElemen2.scanFunction.applyAsInt(reference);
                        if (result >= 0) {
                            if (result == 0) {
                                try {
                                    this.ackTx(tx, reference);
                                    if (scanElemen2.found != null) {
                                        afterCommitList.add(scanElemen2.found);
                                    }
                                }
                                catch (Throwable e) {
                                    logger.warn((Object)e.getMessage(), e);
                                }
                            } else if (scanElemen2.notFound != null) {
                                scanElemen2.notFound.run();
                            }
                            localScanList[i2] = null;
                            continue;
                        }
                        keepMoving = true;
                    }
                    if (keepMoving) continue;
                    break;
                }
            }
            for (int i3 = 0; i3 < localScanList.length; ++i3) {
                if (localScanList[i3] != null && localScanList[i3].notFound != null) {
                    localScanList[i3].notFound.run();
                }
                localScanList[i3] = null;
            }
            if (afterCommitList.size() > 0) {
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
    }

    PageSubscriptionImpl(PageCursorProvider cursorProvider, PagingStore pageStore, StorageManager store, Filter filter, long cursorId, boolean persistent) {
        this.pageStore = pageStore;
        this.store = store;
        this.cursorProvider = cursorProvider;
        this.cursorId = cursorId;
        this.filter = filter;
        this.persistent = persistent;
        this.counter = new PageSubscriptionCounterImpl(store, this, persistent, cursorId);
    }

    @Override
    public PagingStore getPagingStore() {
        return this.pageStore;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public boolean isPaging() {
        return this.pageStore.isPaging();
    }

    @Override
    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    @Override
    public void disableAutoCleanup() {
        this.autoCleanup = false;
    }

    @Override
    public void enableAutoCleanup() {
        this.autoCleanup = true;
    }

    public PageCursorProvider getProvider() {
        return this.cursorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notEmpty() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.empty = false;
        }
    }

    @Override
    public void bookmark(PagePosition position) throws Exception {
        PageCursorInfo cursorInfo = this.getPageInfo(position);
        if (position.getMessageNr() > 0) {
            cursorInfo.confirmed.addAndGet(position.getMessageNr());
        }
        this.confirmPosition(position);
    }

    @Override
    public long getMessageCount() {
        if (this.empty) {
            return 0L;
        }
        return this.counter.getValue() - this.deliveredCount.get();
    }

    @Override
    public long getPersistentSize() {
        if (this.empty) {
            return 0L;
        }
        long messageSize = this.counter.getPersistentSize() - this.deliveredSize.get();
        return messageSize > 0L ? messageSize : 0L;
    }

    @Override
    public PageSubscriptionCounter getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reloadPageCompletion(PagePosition position) throws Exception {
        if (!this.pageStore.checkPageFileExists((int)position.getPageNr())) {
            return false;
        }
        if (this.pageStore.getCurrentPage() != null && this.pageStore.getCurrentPage().getPageId() == position.getPageNr()) {
            this.pageStore.forceAnotherPage();
        }
        PageCursorInfo info = new PageCursorInfo(position.getPageNr(), position.getMessageNr());
        info.setCompleteInfo(position);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.consumedPages.put(position.getPageNr(), info);
        }
        return true;
    }

    @Override
    public void scheduleCleanupCheck() {
        if (this.autoCleanup) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Scheduling cleanup", (Throwable)new Exception("trace"));
            }
            if (this.scheduledCleanupCount.get() > 2) {
                return;
            }
            this.scheduledCleanupCount.incrementAndGet();
            this.pageStore.execute(this::performCleanup);
        }
    }

    private void performCleanup() {
        try {
            if (this.autoCleanup) {
                this.cleanupEntries(false);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.problemCleaningCursorPages(e);
        }
        finally {
            this.scheduledCleanupCount.decrementAndGet();
        }
    }

    @Override
    public void onPageModeCleared(Transaction tx) throws Exception {
        if (this.counter != null) {
            this.counter.delete(tx);
        }
        this.empty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupEntries(final boolean completeDelete) throws Exception {
        if (completeDelete) {
            this.counter.delete();
        }
        logger.trace((Object)">>>>>>> cleanupEntries");
        try {
            TransactionImpl tx = new TransactionImpl(this.store);
            boolean persist = false;
            ArrayList<PageCursorInfo> completedPages = new ArrayList<PageCursorInfo>();
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                block16: {
                    if (this.lastAckedPosition != null) break block16;
                    return;
                }
                for (Map.Entry<Long, PageCursorInfo> entry : this.consumedPages.entrySet()) {
                    PageCursorInfo info = entry.getValue();
                    if (!info.isDone() || info.isPendingDelete()) continue;
                    Page currentPage = this.pageStore.getCurrentPage();
                    if (currentPage != null && entry.getKey().longValue() == this.pageStore.getCurrentPage().getPageId()) {
                        logger.tracef("We can't clear page %s 's the current page", (Object)entry.getKey());
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.tracef("cleanup marking page %s as complete", info.pageId);
                    }
                    info.setPendingDelete();
                    completedPages.add(entry.getValue());
                }
            }
            for (PageCursorInfo infoPG : completedPages) {
                if (this.isPersistent()) {
                    PagePositionImpl completePage = new PagePositionImpl(infoPG.getPageId(), infoPG.getNumberOfMessages());
                    infoPG.setCompleteInfo(completePage);
                    this.store.storePageCompleteTransactional(tx.getID(), this.getId(), completePage);
                    if (!persist) {
                        persist = true;
                        tx.setContainsPersistent();
                    }
                }
                for (PagePosition pos : infoPG.acks.values()) {
                    if (pos.getRecordID() < 0L) continue;
                    this.store.deleteCursorAcknowledgeTransactional(tx.getID(), pos.getRecordID());
                    if (persist) continue;
                    tx.setContainsPersistent();
                    persist = true;
                }
                infoPG.acks.clear();
                infoPG.removedReferences.clear();
            }
            tx.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterCommit(Transaction tx1) {
                    PageSubscriptionImpl.this.pageStore.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (!completeDelete) {
                                PageSubscriptionImpl.this.cursorProvider.scheduleCleanup();
                            }
                        }
                    });
                }
            });
            tx.commit();
        }
        finally {
            logger.trace((Object)"<<<<<< cleanupEntries");
        }
    }

    public String toString() {
        return "PageSubscriptionImpl [cursorId=" + this.cursorId + ", queue=" + this.queue + ", filter = " + this.filter + "]";
    }

    @Override
    public PageIterator iterator() {
        return new CursorIterator();
    }

    @Override
    public PageIterator iterator(boolean browsing) {
        return new CursorIterator(browsing);
    }

    private boolean routed(PagedMessage message) {
        long id = this.getId();
        for (long qid : message.getQueueIDs()) {
            if (qid != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public void confirmPosition(Transaction tx, PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position);
    }

    private void confirmPosition(Transaction tx, PagePosition position, long persistentSize) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledgeTransactional(tx.getID(), this.cursorId, position);
        }
        this.installTXCallback(tx, position, persistentSize);
    }

    @Override
    public void ackTx(Transaction tx, PagedReference reference) throws Exception {
        long persistentSize = this.getPersistentSize(reference);
        this.confirmPosition(tx, reference.getPagedMessage().newPositionObject(), persistentSize);
        this.counter.increment(tx, -1, -persistentSize);
        PageTransactionInfo txInfo = this.getPageTransaction(reference);
        if (txInfo != null) {
            txInfo.storeUpdate(this.store, this.pageStore.getPagingManager(), tx);
        }
    }

    @Override
    public void ack(PagedReference reference) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.store);
        this.ackTx(tx, reference);
        tx.commit();
    }

    @Override
    public boolean contains(PagedReference ref) throws Exception {
        boolean routed = false;
        for (long idRef : ref.getPagedMessage().getQueueIDs()) {
            if (idRef != this.cursorId) continue;
            routed = true;
            break;
        }
        if (!routed) {
            return false;
        }
        return !this.getPageInfo(ref.getPagedMessage().getPageNumber()).isAck(ref.getPagedMessage().getMessageNumber());
    }

    @Override
    public void confirmPosition(final PagePosition position) throws Exception {
        if (this.persistent) {
            this.store.storeCursorAcknowledge(this.cursorId, position);
        }
        this.store.afterCompleteOperations(new IOCallback(){
            volatile String error = "";

            public void onError(int errorCode, String errorMessage) {
                this.error = " errorCode=" + errorCode + ", msg=" + errorMessage;
                ActiveMQServerLogger.LOGGER.pageSubscriptionError(this, this.error);
            }

            public void done() {
                PageSubscriptionImpl.this.processACK(position);
            }

            public String toString() {
                return IOCallback.class.getSimpleName() + "(" + PageSubscriptionImpl.class.getSimpleName() + ") " + this.error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFirstPage() {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            if (this.empty && this.consumedPages.isEmpty()) {
                return -1L;
            }
            long lastPageSeen = 0L;
            for (Map.Entry<Long, PageCursorInfo> info : this.consumedPages.entrySet()) {
                lastPageSeen = info.getKey();
                if (info.getValue().isDone() || info.getValue().isPendingDelete()) continue;
                return info.getKey();
            }
            return lastPageSeen;
        }
    }

    @Override
    public void addPendingDelivery(PagedMessage pagedMessage) {
        PageCursorInfo info = this.getPageInfo(pagedMessage.getPageNumber());
        if (info != null) {
            info.incrementPendingTX();
        }
    }

    @Override
    public void removePendingDelivery(PagedMessage pagedMessage) {
        PageCursorInfo info = this.getPageInfo(pagedMessage.getPageNumber());
        if (info != null) {
            info.decrementPendingTX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliver(PageIterator iterator, PagedReference pagedReference) {
        iterator.redeliver(pagedReference);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pagedReference.getPagedMessage().getPageNumber());
            if (pageInfo != null) {
                pageInfo.decrementPendingTX();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PagedMessage queryMessage(PagePosition pos) {
        PagedMessage pagedMessage;
        Page page = this.pageStore.usePage(pos.getPageNr());
        if (page == null) {
            return null;
        }
        try {
            LinkedList<PagedMessage> messages = page.getMessages();
            PagedMessage retMessage = pos.getMessageNr() < messages.size() ? (PagedMessage)messages.get(pos.getMessageNr()) : null;
            pagedMessage = retMessage;
            page.usageDown();
        }
        catch (Throwable throwable) {
            try {
                page.usageDown();
                throw throwable;
            }
            catch (Exception e) {
                this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return pagedMessage;
    }

    @Override
    public void reloadACK(PagePosition position) {
        if (this.recoveredACK == null) {
            this.recoveredACK = new java.util.LinkedList<PagePosition>();
        }
        this.recoveredACK.add(position);
    }

    @Override
    public void reloadPreparedACK(Transaction tx, PagePosition position) {
        this.deliveredCount.incrementAndGet();
        this.installTXCallback(tx, position);
    }

    @Override
    public void positionIgnored(PagePosition position) {
        this.processACK(position);
    }

    @Override
    public void lateDeliveryRollback(PagePosition position) {
        PageCursorInfo cursorInfo = this.processACK(position);
        cursorInfo.decrementPendingTX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachConsumedPage(Consumer<ConsumedPage> pageCleaner) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            this.consumedPages.values().forEach(pageCleaner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete(long page) {
        logger.tracef("%s isComplete %d", (Object)this, (Object)page);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            boolean isDone;
            if (this.empty && this.consumedPages.isEmpty()) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("isComplete(%d)::Subscription %s has empty=%s, consumedPages.isEmpty=%s", new Object[]{page, this, this.empty, this.consumedPages.isEmpty()});
                }
                return true;
            }
            PageCursorInfo info = (PageCursorInfo)this.consumedPages.get(page);
            if (info == null && this.empty) {
                logger.tracef("isComplete(%d)::::Couldn't find info and it is empty", page);
                return true;
            }
            boolean bl = isDone = info != null && info.isDone();
            if (logger.isTraceEnabled()) {
                logger.tracef("isComplete(%d):: found info=%s, isDone=%s", (Object)page, (Object)info, (Object)isDone);
            }
            return isDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws Exception {
        long tx = this.store.generateID();
        try {
            boolean isPersistent = false;
            SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
            synchronized (sortedMap) {
                for (PageCursorInfo cursor : this.consumedPages.values()) {
                    for (PagePosition info : cursor.acks.values()) {
                        if (info.getRecordID() < 0L) continue;
                        isPersistent = true;
                        this.store.deleteCursorAcknowledgeTransactional(tx, info.getRecordID());
                    }
                    PagePosition completeInfo = cursor.getCompleteInfo();
                    if (completeInfo == null || completeInfo.getRecordID() < 0L) continue;
                    this.store.deletePageComplete(completeInfo.getRecordID());
                    cursor.setCompleteInfo(null);
                }
            }
            if (isPersistent) {
                this.store.commit(tx);
            }
            this.cursorProvider.close(this);
        }
        catch (Exception e) {
            try {
                this.store.rollback(tx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public long getId() {
        return this.cursorId;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void processReload() throws Exception {
        if (this.recoveredACK != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"********** processing reload!!!!!!!");
            }
            Collections.sort(this.recoveredACK);
            long txDeleteCursorOnReload = -1L;
            Iterator<PagePosition> iterator = this.recoveredACK.iterator();
            while (iterator.hasNext()) {
                PagePosition pos;
                this.lastAckedPosition = pos = iterator.next();
                PageCursorInfo pageInfo = this.getPageInfo(pos);
                pageInfo.loadACK(pos);
            }
            if (txDeleteCursorOnReload >= 0L) {
                this.store.commit(txDeleteCursorOnReload);
            }
            this.recoveredACK.clear();
            this.recoveredACK = null;
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void printDebug() {
        this.printDebug(this.toString());
    }

    public void printDebug(String msg) {
        System.out.println("Debug information on PageCurorImpl- " + msg);
        for (PageCursorInfo info : this.consumedPages.values()) {
            System.out.println(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeletePage(Page deletedPage) throws Exception {
        PageCursorInfo info;
        logger.tracef("removing page %s", (Object)deletedPage);
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            info = (PageCursorInfo)this.consumedPages.remove(deletedPage.getPageId());
        }
        if (info != null) {
            PagePosition completeInfo = info.getCompleteInfo();
            if (completeInfo != null) {
                try {
                    this.store.deletePageComplete(completeInfo.getRecordID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                }
                info.setCompleteInfo(null);
            }
            for (PagePosition deleteInfo : info.acks.values()) {
                if (deleteInfo.getRecordID() < 0L) continue;
                try {
                    this.store.deleteCursorAcknowledge(deleteInfo.getRecordID());
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorDeletingPageCompleteRecord(e);
                }
            }
            info.acks.clear();
        }
        deletedPage.usageExhaust();
    }

    @Override
    public void reloadPageInfo(long pageNr) {
        this.getPageInfo(pageNr);
    }

    PageCursorInfo getPageInfo(PagePosition pos) {
        return this.getPageInfo(pos.getPageNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageCursorInfo getPageInfo(long pageNr) {
        SortedMap<Long, PageCursorInfo> sortedMap = this.consumedPages;
        synchronized (sortedMap) {
            PageCursorInfo pageInfo = (PageCursorInfo)this.consumedPages.get(pageNr);
            if (pageInfo == null) {
                pageInfo = new PageCursorInfo(pageNr);
                this.consumedPages.put(pageNr, pageInfo);
            }
            return pageInfo;
        }
    }

    private boolean match(Message message) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.match(message);
    }

    private PageCursorInfo processACK(PagePosition pos) {
        PageCursorInfo info;
        if (this.lastAckedPosition == null || pos.compareTo(this.lastAckedPosition) > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"a new position is being processed as ACK");
            }
            if (this.lastAckedPosition != null && this.lastAckedPosition.getPageNr() != pos.getPageNr()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Scheduling cleanup on pageSubscription for address = " + this.pageStore.getAddress() + " queue = " + this.getQueue().getName()));
                }
                if (this.autoCleanup) {
                    this.scheduleCleanupCheck();
                }
            }
            this.lastAckedPosition = pos;
        }
        if ((info = this.getPageInfo(pos)) == null) {
            ActiveMQServerLogger.LOGGER.nullPageCursorInfo(this.getPagingStore().getAddress().toString(), pos.toString(), this.cursorId);
        } else {
            info.addACK(pos);
        }
        return info;
    }

    private void installTXCallback(Transaction tx, PagePosition position) {
        this.installTXCallback(tx, position, -1L);
    }

    private void installTXCallback(Transaction tx, PagePosition position, long persistentSize) {
        PageCursorInfo info;
        if (position.getRecordID() >= 0L) {
            tx.setContainsPersistent();
        }
        if ((info = this.getPageInfo(position)) != null) {
            logger.tracef("InstallTXCallback looking up pagePosition %s, result=%s", (Object)position, (Object)info);
            info.remove(position.getMessageNr());
            PageCursorTX cursorTX = (PageCursorTX)tx.getProperty(8);
            if (cursorTX == null) {
                cursorTX = new PageCursorTX();
                tx.putProperty(8, cursorTX);
                tx.addOperation(cursorTX);
            }
            cursorTX.addPositionConfirmation(this, position);
        }
    }

    private PageTransactionInfo getPageTransaction(PagedReference reference) throws ActiveMQException {
        if (reference.getTransactionID() >= 0L) {
            return this.pageStore.getPagingManager().getTransaction(reference.getTransactionID());
        }
        return null;
    }

    private void onPageDone(PageCursorInfo info) {
        if (this.autoCleanup) {
            if (logger.isTraceEnabled()) {
                logger.tracef("onPageDone page %s", info.getPageId());
            }
            this.scheduleCleanupCheck();
        }
    }

    @Override
    public long getDeliveredCount() {
        return this.deliveredCount.get();
    }

    @Override
    public long getDeliveredSize() {
        return this.deliveredSize.get();
    }

    @Override
    public void incrementDeliveredSize(long size) {
        this.deliveredSize.addAndGet(size);
    }

    private long getPersistentSize(PagedMessage msg) {
        try {
            return msg != null && msg.getPersistentSize() > 0L ? msg.getPersistentSize() : 0L;
        }
        catch (ActiveMQException e) {
            logger.warn((Object)("Error computing persistent size of message: " + msg), (Throwable)e);
            return 0L;
        }
    }

    private long getPersistentSize(PagedReference ref) {
        try {
            return ref != null && ref.getPersistentSize() > 0L ? ref.getPersistentSize() : 0L;
        }
        catch (ActiveMQException e) {
            logger.warn((Object)("Error computing persistent size of message: " + ref), (Throwable)e);
            return 0L;
        }
    }

    private class CursorIterator
    implements PageIterator {
        private Page currentPage;
        private LinkedListIterator<PagedMessage> currentPageIterator;
        private PagedReference currentDelivery = null;
        private volatile PagedReference lastDelivery = null;
        private final boolean browsing;
        private final java.util.Queue<PagedReference> redeliveries = new java.util.LinkedList<PagedReference>();
        private volatile PagedReference cachedNext;

        private void initPage(long page) {
            try {
                if (this.currentPage != null) {
                    this.currentPage.usageDown();
                }
                if (this.currentPageIterator != null) {
                    this.currentPageIterator.close();
                }
                this.currentPage = PageSubscriptionImpl.this.pageStore.usePage(page);
                if (logger.isTraceEnabled()) {
                    logger.tracef("CursorIterator: getting page " + page + " which will contain " + this.currentPage.getNumberOfMessages(), new Object[0]);
                }
                this.currentPageIterator = this.currentPage.iterator();
            }
            catch (Exception e) {
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        private CursorIterator(boolean browsing) {
            this.browsing = browsing;
        }

        private CursorIterator() {
            this.browsing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redeliver(PagedReference reference) {
            java.util.Queue<PagedReference> queue = this.redeliveries;
            synchronized (queue) {
                this.redeliveries.add(reference);
            }
        }

        public void repeat() {
            this.cachedNext = this.lastDelivery;
        }

        public synchronized PagedReference next() {
            try {
                if (this.cachedNext != null) {
                    this.currentDelivery = this.cachedNext;
                    this.cachedNext = null;
                    return this.currentDelivery;
                }
                if (this.currentPage == null) {
                    logger.tracef("CursorIterator::next initializing first page as %s", PageSubscriptionImpl.this.pageStore.getFirstPage());
                    this.initPage(PageSubscriptionImpl.this.pageStore.getFirstPage());
                }
                this.currentDelivery = this.moveNext();
                return this.currentDelivery;
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PagedReference moveNext() {
            PageSubscriptionImpl pageSubscriptionImpl = PageSubscriptionImpl.this;
            synchronized (pageSubscriptionImpl) {
                PagedReference message;
                boolean match = false;
                long timeout = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
                do {
                    if (System.nanoTime() - timeout > 0L) {
                        return RETRY_MARK;
                    }
                    java.util.Queue<PagedReference> queue = this.redeliveries;
                    synchronized (queue) {
                        PagedReference redelivery = this.redeliveries.poll();
                        if (redelivery != null) {
                            return redelivery;
                        }
                        this.lastDelivery = null;
                    }
                    message = this.internalGetNext();
                    if (message == null) break;
                    boolean valid = true;
                    boolean ignored = false;
                    valid = PageSubscriptionImpl.this.routed(message.getPagedMessage());
                    if (!valid) {
                        logger.tracef("CursorIterator::message %s was deemed invalid, marking it to ignore", (Object)message.getPagedMessage());
                        ignored = true;
                    }
                    PageCursorInfo info = PageSubscriptionImpl.this.getPageInfo(message.getPagedMessage().getPageNumber());
                    if (!this.browsing && info != null && (info.isRemoved(message.getPagedMessage().getMessageNumber()) || info.getCompleteInfo() != null)) {
                        if (!logger.isTraceEnabled()) continue;
                        boolean removed = info.isRemoved(message.getPagedMessage().getMessageNumber());
                        logger.tracef("CursorIterator::Message from page %s # %s isRemoved=%s", message.getPagedMessage().getPageNumber(), (long)message.getPagedMessage().getMessageNumber(), (Object)removed);
                        continue;
                    }
                    if (info != null && info.isAck(message.getPagedMessage().getMessageNumber())) {
                        logger.tracef("CursorIterator::message %s is acked, moving next", (Object)message);
                        continue;
                    }
                    if (valid && message.getPagedMessage().getTransactionID() >= 0L) {
                        PageTransactionInfo tx = PageSubscriptionImpl.this.pageStore.getPagingManager().getTransaction(message.getPagedMessage().getTransactionID());
                        if (tx == null) {
                            ActiveMQServerLogger.LOGGER.pageSubscriptionCouldntLoad(message.getPagedMessage().getTransactionID(), message.getPagedMessage().newPositionObject(), PageSubscriptionImpl.this.pageStore.getAddress(), PageSubscriptionImpl.this.queue.getName());
                            valid = false;
                            ignored = true;
                        } else if (tx.deliverAfterCommit(this, PageSubscriptionImpl.this, message)) {
                            valid = false;
                            ignored = false;
                        }
                    }
                    if (valid && !this.browsing && info != null && info.isRemoved(message.getPagedMessage().getMessageNumber())) {
                        valid = false;
                    }
                    if (valid) {
                        if (this.browsing) {
                            match = PageSubscriptionImpl.this.match(message.getMessage());
                            continue;
                        }
                        match = true;
                        continue;
                    }
                    if (this.browsing || !ignored) continue;
                    PageSubscriptionImpl.this.positionIgnored(message.getPagedMessage().newPositionObject());
                } while (!match);
                if (message != null) {
                    this.lastDelivery = message;
                }
                return message;
            }
        }

        private PagedReference internalGetNext() {
            while (true) {
                PagedMessage message = this.currentPageIterator.hasNext() ? (PagedMessage)this.currentPageIterator.next() : null;
                logger.tracef("CursorIterator::internalGetNext:: new reference %s", (Object)message);
                if (message != null) {
                    return PageSubscriptionImpl.this.cursorProvider.newReference(message, PageSubscriptionImpl.this);
                }
                if (this.currentPage.getPageId() >= PageSubscriptionImpl.this.pageStore.getCurrentWritingPage()) break;
                if (logger.isTraceEnabled()) {
                    logger.tracef("CursorIterator::internalGetNext:: moving to currentPage %s", this.currentPage.getPageId() + 1L);
                }
                this.initPage(this.currentPage.getPageId() + 1L);
            }
            return null;
        }

        @Override
        public synchronized PageIterator.NextResult tryNext() {
            if (this.cachedNext != null) {
                return PageIterator.NextResult.hasElements;
            }
            if (!PageSubscriptionImpl.this.pageStore.isPaging()) {
                return PageIterator.NextResult.noElements;
            }
            PagedReference pagedReference = this.next();
            if (pagedReference == RETRY_MARK) {
                return PageIterator.NextResult.retry;
            }
            this.cachedNext = pagedReference;
            return this.cachedNext == null ? PageIterator.NextResult.noElements : PageIterator.NextResult.hasElements;
        }

        public synchronized boolean hasNext() {
            PageIterator.NextResult status;
            while ((status = this.tryNext()) == PageIterator.NextResult.retry) {
            }
            return status == PageIterator.NextResult.hasElements;
        }

        public void remove() {
            PageCursorInfo info;
            PageSubscriptionImpl.this.deliveredCount.incrementAndGet();
            PagedReference delivery = this.currentDelivery;
            if (delivery != null && (info = PageSubscriptionImpl.this.getPageInfo(delivery.getPagedMessage().getPageNumber())) != null) {
                info.remove(delivery.getPagedMessage().getMessageNumber());
            }
        }

        public void close() {
            Page toClose = this.currentPage;
            if (toClose != null) {
                toClose.usageDown();
            }
            this.currentPage = null;
        }
    }

    private final class PageCursorTX
    extends TransactionOperationAbstract {
        private final Map<PageSubscriptionImpl, List<PagePosition>> pendingPositions = new HashMap<PageSubscriptionImpl, List<PagePosition>>();

        private PageCursorTX() {
        }

        private void addPositionConfirmation(PageSubscriptionImpl cursor, PagePosition position) {
            List<PagePosition> list = this.pendingPositions.get(cursor);
            if (list == null) {
                list = new java.util.LinkedList<PagePosition>();
                this.pendingPositions.put(cursor, list);
            }
            list.add(position);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageSubscriptionImpl, List<PagePosition>> entry : this.pendingPositions.entrySet()) {
                PageSubscriptionImpl cursor = entry.getKey();
                List<PagePosition> positions = entry.getValue();
                for (PagePosition confirmed : positions) {
                    cursor.processACK(confirmed);
                    cursor.deliveredCount.decrementAndGet();
                    cursor.deliveredSize.addAndGet(-confirmed.getPersistentSize());
                }
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }

    public final class PageCursorInfo
    implements ConsumedPage {
        private int numberOfMessages;
        private final long pageId;
        private IntObjectHashMap<PagePosition> acks = new IntObjectHashMap();
        private IntObjectHashMap<Object> removedReferences = new IntObjectHashMap();
        private final AtomicInteger pendingTX = new AtomicInteger(0);
        private boolean pendingDelete;
        private PagePosition completePage;
        private final AtomicInteger confirmed = new AtomicInteger(0);

        public synchronized boolean isAck(int messageNumber) {
            return this.completePage != null || this.acks.get(messageNumber) != null;
        }

        public String toString() {
            try {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + this.isDone();
            }
            catch (Exception e) {
                return "PageCursorInfo::pageNr=" + this.pageId + " numberOfMessage = " + this.numberOfMessages + ", confirmed = " + this.confirmed + ", isDone=" + e.toString();
            }
        }

        PageCursorInfo(long pageId, int numberOfMessages) {
            if (numberOfMessages < 0) {
                throw new IllegalStateException("numberOfMessages = " + numberOfMessages + " instead of being >=0");
            }
            this.pageId = pageId;
            this.numberOfMessages = numberOfMessages;
            logger.tracef("Created PageCursorInfo for pageNr=%d, numberOfMessages=%d, not live", pageId, (long)numberOfMessages);
        }

        private PageCursorInfo(long pageId) {
            this.pageId = pageId;
            this.numberOfMessages = -1;
        }

        public void setCompleteInfo(PagePosition completePage) {
            logger.tracef("Setting up complete page %s on cursor %s on subscription %s", (Object)completePage, (Object)this, (Object)PageSubscriptionImpl.this);
            this.completePage = completePage;
        }

        public PagePosition getCompleteInfo() {
            return this.completePage;
        }

        @Override
        public boolean isDone() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(PageSubscriptionImpl.this + "::PageCursorInfo(" + this.pageId + ")::isDone checking with completePage!=null->" + (this.completePage != null) + " getNumberOfMessages=" + this.getNumberOfMessages() + ", confirmed=" + this.confirmed.get() + " and pendingTX=" + this.pendingTX.get()));
            }
            return this.completePage != null || this.confirmed.get() >= this.getNumberOfMessages() && this.pendingTX.get() == 0;
        }

        public boolean isPendingDelete() {
            return this.pendingDelete || this.completePage != null;
        }

        public void setPendingDelete() {
            this.pendingDelete = true;
        }

        @Override
        public long getPageId() {
            return this.pageId;
        }

        public void incrementPendingTX() {
            this.pendingTX.incrementAndGet();
        }

        public void decrementPendingTX() {
            this.pendingTX.decrementAndGet();
            this.checkDone();
        }

        public synchronized boolean isRemoved(int messageNr) {
            return this.removedReferences.get(messageNr) != null;
        }

        public synchronized void remove(int messageNr) {
            if (logger.isTraceEnabled()) {
                logger.tracef("PageCursor Removing messageNr %s on page %s", (long)messageNr, this.pageId);
            }
            this.removedReferences.put(messageNr, DUMMY);
        }

        public void addACK(PagePosition posACK) {
            boolean added;
            if (logger.isTraceEnabled()) {
                try {
                    logger.trace((Object)("numberOfMessages =  " + this.getNumberOfMessages() + " confirmed =  " + (this.confirmed.get() + 1) + " pendingTX = " + this.pendingTX + ", pageNr = " + this.pageId + " posACK = " + posACK));
                }
                catch (Throwable ignored) {
                    logger.debug((Object)ignored.getMessage(), ignored);
                }
            }
            if ((added = this.internalAddACK(posACK)) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
                this.checkDone();
            }
        }

        public void loadACK(PagePosition posACK) {
            if (this.internalAddACK(posACK) && posACK.getMessageNr() >= 0) {
                this.confirmed.incrementAndGet();
            }
        }

        synchronized boolean internalAddACK(PagePosition position) {
            this.removedReferences.put(position.getMessageNr(), DUMMY);
            return this.acks.put(position.getMessageNr(), (Object)position) == null;
        }

        protected void checkDone() {
            if (this.isDone()) {
                PageSubscriptionImpl.this.onPageDone(this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getNumberOfMessages() {
            if (this.numberOfMessages >= 0) return this.numberOfMessages;
            try {
                Page page = PageSubscriptionImpl.this.pageStore.usePage(this.pageId, false);
                if (page == null) {
                    page = PageSubscriptionImpl.this.pageStore.newPageObject(this.pageId);
                    this.numberOfMessages = page.readNumberOfMessages();
                    return this.numberOfMessages;
                }
                try {
                    if (page.isOpen()) {
                        int n = page.getNumberOfMessages();
                        return n;
                    }
                    this.numberOfMessages = page.getNumberOfMessages();
                    return this.numberOfMessages;
                }
                finally {
                    page.usageDown();
                }
            }
            catch (Exception e) {
                PageSubscriptionImpl.this.store.criticalError(e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public int getPendingTx() {
            return this.pendingTX.get();
        }
    }

    private static class PageScan {
        final BooleanSupplier retryBeforeScan;
        final ToIntFunction<PagedReference> scanFunction;
        final Runnable found;
        final Runnable notFound;

        public ToIntFunction<PagedReference> getScanFunction() {
            return this.scanFunction;
        }

        public Runnable getFound() {
            return this.found;
        }

        public Runnable getNotfound() {
            return this.notFound;
        }

        PageScan(BooleanSupplier retryBeforeScan, ToIntFunction<PagedReference> scanFunction, Runnable found, Runnable notFound) {
            this.retryBeforeScan = retryBeforeScan;
            this.scanFunction = scanFunction;
            this.found = found;
            this.notFound = notFound;
        }
    }
}

