/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStoreLiveActivation;

public class SharedStoreMasterPolicy
implements HAPolicy<LiveActivation> {
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean waitForActivation = ActiveMQDefaultConfiguration.isDefaultWaitForActivation();
    private SharedStoreSlavePolicy sharedStoreSlavePolicy;

    public SharedStoreMasterPolicy() {
    }

    public SharedStoreMasterPolicy(boolean failoverOnServerShutdown, boolean waitForActivation) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.waitForActivation = waitForActivation;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    @Override
    public boolean isWaitForActivation() {
        return this.waitForActivation;
    }

    public void setWaitForActivation(boolean waitForActivation) {
        this.waitForActivation = waitForActivation;
    }

    public SharedStoreSlavePolicy getSharedStoreSlavePolicy() {
        return this.sharedStoreSlavePolicy;
    }

    public void setSharedStoreSlavePolicy(SharedStoreSlavePolicy sharedStoreSlavePolicy) {
        this.sharedStoreSlavePolicy = sharedStoreSlavePolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public LiveActivation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedStoreLiveActivation(server, this, ioCriticalErrorListener);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }
}

