/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class PGPPBEEncryptedData
extends PGPSymmetricKeyEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getEncAlgorithm();
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
        return byArray2[0];
    }

    public PGPSessionKey getSessionKey(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        byte[] byArray = pBEDataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] byArray2 = pBEDataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), byArray, this.keyData.getSecKeyData());
        return new PGPSessionKey(byArray2[0] & 0xFF, Arrays.copyOfRange((byte[])byArray2, (int)1, (int)byArray2.length));
    }

    public InputStream getDataStream(PBEDataDecryptorFactory pBEDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = this.getSessionKey(pBEDataDecryptorFactory);
            this.encStream = this.createDecryptionStream(pBEDataDecryptorFactory, pGPSessionKey);
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey pGPSessionKey = sessionKeyDataDecryptorFactory.getSessionKey();
            this.encStream = this.createDecryptionStream(sessionKeyDataDecryptorFactory, pGPSessionKey);
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

