/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingOptions;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmMassIdentifierLoader<E, I>
implements PojoMassIdentifierLoader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassLoadingOptions options;
    private final PojoMassIdentifierSink<I> sink;
    private final SharedSessionContractImplementor session;
    private final TransactionHelper transactionHelper;
    private final long totalCount;
    private long totalLoaded = 0L;
    private final ScrollableResults<I> results;

    public HibernateOrmMassIdentifierLoader(HibernateOrmQueryLoader<E, I> typeQueryLoader, HibernateOrmMassLoadingOptions options, PojoMassIdentifierSink<I> sink, SharedSessionContractImplementor session) {
        this.options = options;
        this.sink = sink;
        this.session = session;
        this.transactionHelper = new TransactionHelper(session.getFactory(), options.idLoadingTransactionTimeout());
        this.transactionHelper.begin(session);
        try {
            long objectsLimit = options.objectsLimit();
            long totalCountFromQuery = (Long)typeQueryLoader.createCountQuery(session).setCacheable(false).uniqueResult();
            this.totalCount = objectsLimit != 0L && objectsLimit < totalCountFromQuery ? objectsLimit : totalCountFromQuery;
            if (log.isDebugEnabled()) {
                log.debugf("going to fetch %d primary keys", this.totalCount);
            }
            this.results = typeQueryLoader.createIdentifiersQuery(session).setCacheable(false).setFetchSize(options.idFetchSize()).scroll(ScrollMode.FORWARD_ONLY);
        }
        catch (RuntimeException e) {
            this.transactionHelper.rollbackSafely(session, e);
            throw e;
        }
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ScrollableResults::close, this.results);
            closer.push(h -> h.commit(this.session), (Object)this.transactionHelper);
            closer.push(SharedSessionContract::close, (Object)this.session);
        }
    }

    public long totalCount() {
        return this.totalCount;
    }

    public void loadNext() throws InterruptedException {
        int batchSize = this.options.objectLoadingBatchSize();
        ArrayList<Object> destinationList = new ArrayList<Object>(batchSize);
        while (destinationList.size() < batchSize && this.totalLoaded < this.totalCount && this.results.next()) {
            Object id = this.results.get();
            destinationList.add(id);
            ++this.totalLoaded;
        }
        if (destinationList.isEmpty()) {
            this.sink.complete();
        } else {
            if (!this.session.isTransactionInProgress()) {
                throw log.transactionNotActiveWhileProducingIdsForBatchIndexing();
            }
            this.sink.accept(destinationList);
        }
    }
}

