/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.participant.service;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.ServletException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.wildfly.extension.microprofile.lra.participant._private.MicroProfileLRAParticipantLogger;
import org.wildfly.extension.microprofile.lra.participant.jaxrs.LRAParticipantApplication;
import org.wildfly.extension.undertow.Host;

public final class LRAParticipantService
implements Service {
    public static final String CONTEXT_PATH = "/lra-participant-narayana-proxy";
    private static final String DEPLOYMENT_NAME = "LRA Participant Proxy";
    private final Supplier<Host> undertow;
    private volatile DeploymentManager deploymentManager = null;
    private volatile Deployment deployment = null;

    public LRAParticipantService(Supplier<Host> undertow) {
        this.undertow = undertow;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.deployParticipantProxy();
    }

    public synchronized void stop(StopContext context) {
        try {
            this.undeployServlet();
        }
        finally {
            System.clearProperty("lra.coordinator.url");
        }
    }

    private void deployParticipantProxy() {
        this.undeployServlet();
        HashMap<String, String> initialParameters = new HashMap<String, String>();
        initialParameters.put("jakarta.ws.rs.Application", LRAParticipantApplication.class.getName());
        MicroProfileLRAParticipantLogger.LOGGER.startingParticipantProxy(CONTEXT_PATH);
        DeploymentInfo participantProxyDeploymentInfo = this.getDeploymentInfo(DEPLOYMENT_NAME, CONTEXT_PATH, initialParameters);
        this.deployServlet(participantProxyDeploymentInfo);
    }

    private DeploymentInfo getDeploymentInfo(String name, String contextPath, Map<String, String> initialParameters) {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        deploymentInfo.setClassLoader(LRAParticipantApplication.class.getClassLoader());
        deploymentInfo.setContextPath(contextPath);
        deploymentInfo.setDeploymentName(name);
        ServletInfo restEasyServlet = new ServletInfo("RESTEasy", HttpServletDispatcher.class).addMapping("/*");
        deploymentInfo.addServlets(new ServletInfo[]{restEasyServlet});
        ListenerInfo restEasyListener = new ListenerInfo(ResteasyBootstrap.class);
        deploymentInfo.addListener(restEasyListener);
        for (Map.Entry<String, String> entry : initialParameters.entrySet()) {
            deploymentInfo.addInitParameter(entry.getKey(), entry.getValue());
        }
        return deploymentInfo;
    }

    private void deployServlet(DeploymentInfo deploymentInfo) {
        this.deploymentManager = ServletContainer.Factory.newInstance().addDeployment(deploymentInfo);
        this.deploymentManager.deploy();
        this.deployment = this.deploymentManager.getDeployment();
        try {
            this.undertow.get().registerDeployment(this.deployment, this.deploymentManager.start());
        }
        catch (ServletException e) {
            this.deployment = null;
        }
    }

    private void undeployServlet() {
        if (this.deploymentManager != null) {
            if (this.deployment != null) {
                this.undertow.get().unregisterDeployment(this.deployment);
                this.deployment = null;
            }
            try {
                this.deploymentManager.stop();
            }
            catch (ServletException e) {
                MicroProfileLRAParticipantLogger.LOGGER.failedStoppingParticipant(CONTEXT_PATH, e);
            }
            finally {
                this.deploymentManager.undeploy();
            }
            this.deploymentManager = null;
        }
    }
}

