/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.hornetq;

import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.SelectorTranslator;

public class HQFilterConversionInterceptor
implements Interceptor {
    public boolean intercept(Packet packet, RemotingConnection connection) {
        if (packet.getType() == 40) {
            this.handleMessage((SessionCreateConsumerMessage)packet);
        } else if (packet.getType() == 34 || packet.getType() == -12) {
            this.handleMessage((CreateQueueMessage)packet);
        } else if (packet.getType() == 36 || packet.getType() == -13) {
            this.handleMessage((CreateSharedQueueMessage)packet);
        }
        return true;
    }

    private void handleMessage(SessionCreateConsumerMessage message) {
        message.setFilterString(this.replaceFilterString(message.getFilterString()));
    }

    private void handleMessage(CreateQueueMessage message) {
        message.setFilterString(this.replaceFilterString(message.getFilterString()));
    }

    private void handleMessage(CreateSharedQueueMessage message) {
        message.setFilterString(this.replaceFilterString(message.getFilterString()));
    }

    private SimpleString replaceFilterString(SimpleString filterString) {
        if (filterString == null) {
            return null;
        }
        return SimpleString.toSimpleString((String)HQFilterConversionInterceptor.convertHQToActiveMQFilterString(filterString.toString()));
    }

    public static String convertHQToActiveMQFilterString(String hqFilterString) {
        if (hqFilterString == null) {
            return null;
        }
        String filterString = SelectorTranslator.parse((String)hqFilterString, (String)"HQDurable", (String)"AMQDurable");
        filterString = SelectorTranslator.parse((String)filterString, (String)"HQPriority", (String)"AMQPriority");
        filterString = SelectorTranslator.parse((String)filterString, (String)"HQTimestamp", (String)"AMQTimestamp");
        filterString = SelectorTranslator.parse((String)filterString, (String)"HQUserID", (String)"AMQUserID");
        filterString = SelectorTranslator.parse((String)filterString, (String)"HQExpiration", (String)"AMQExpiration");
        return filterString;
    }
}

