/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.io.File;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCFileUtils;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;

public class JDBCSequentialFileFactory
implements SequentialFileFactory,
ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(JDBCSequentialFile.class);
    private boolean started;
    private final Set<JDBCSequentialFile> files = new ConcurrentHashSet();
    private final Executor executor;
    private final Map<String, Object> fileLocks = new ConcurrentHashMap<String, Object>();
    private JDBCSequentialFileFactoryDriver dbDriver;
    private final IOCriticalErrorListener criticalErrorListener;

    public JDBCSequentialFileFactory(JDBCConnectionProvider connectionProvider, SQLProvider sqlProvider, Executor executor, IOCriticalErrorListener criticalErrorListener) throws Exception {
        this.executor = executor;
        this.criticalErrorListener = criticalErrorListener;
        try {
            this.dbDriver = JDBCFileUtils.getDBFileDriver(connectionProvider, sqlProvider);
        }
        catch (SQLException e) {
            criticalErrorListener.onIOException((Throwable)e, "Failed to start JDBC Driver", null);
        }
    }

    public JDBCSequentialFileFactoryDriver getDbDriver() {
        return this.dbDriver;
    }

    public SequentialFileFactory setDatasync(boolean enabled) {
        return this;
    }

    public boolean isDatasync() {
        return false;
    }

    public long getBufferSize() {
        return this.dbDriver.getMaxSize();
    }

    public synchronized void start() {
        try {
            if (!this.started) {
                this.dbDriver.start();
                this.started = true;
            }
        }
        catch (Exception e) {
            this.criticalErrorListener.onIOException((Throwable)e, "Unable to start database driver", null);
            this.started = false;
        }
    }

    public synchronized void stop() {
        try {
            this.dbDriver.stop();
        }
        catch (SQLException e) {
            ActiveMQJournalLogger.LOGGER.error((Object)"Error stopping file factory, unable to close db connection");
        }
        this.started = false;
    }

    public SequentialFile createSequentialFile(String fileName) {
        try {
            this.fileLocks.putIfAbsent(fileName, new Object());
            JDBCSequentialFile file = new JDBCSequentialFile(this, fileName, this.executor, this.dbDriver, this.fileLocks.get(fileName));
            this.files.add(file);
            return file;
        }
        catch (Exception e) {
            this.criticalErrorListener.onIOException((Throwable)e, "Error whilst creating JDBC file", null);
            return null;
        }
    }

    public void sequentialFileClosed(SequentialFile file) {
        this.files.remove(file);
    }

    public int getNumberOfOpenFiles() {
        return this.files.size();
    }

    public int getMaxIO() {
        return 1;
    }

    public List<String> listFiles(String extension) throws Exception {
        try {
            return this.dbDriver.listFiles(extension);
        }
        catch (SQLException e) {
            this.criticalErrorListener.onIOException((Throwable)e, "Error listing JDBC files.", null);
            throw e;
        }
    }

    public boolean isSupportsCallbacks() {
        return true;
    }

    public void onIOError(Exception exception, String message, SequentialFile file) {
        this.criticalErrorListener.onIOException((Throwable)exception, message, file);
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public int getAlignment() {
        return 1;
    }

    public JDBCSequentialFileFactory setAlignment(int alignment) {
        return this;
    }

    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    public void deactivateBuffer() {
    }

    public void releaseBuffer(ByteBuffer buffer) {
    }

    public void activateBuffer(SequentialFile file) {
    }

    public File getDirectory() {
        return null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void createDirs() throws Exception {
    }

    public void flush() {
        for (SequentialFile sequentialFile : this.files) {
            try {
                sequentialFile.sync();
            }
            catch (Exception e) {
                this.criticalErrorListener.onIOException((Throwable)e, "Error during JDBC file sync.", sequentialFile);
            }
        }
    }

    public synchronized void destroy() throws SQLException {
        try {
            this.dbDriver.destroy();
        }
        catch (SQLException e) {
            logger.error((Object)"Error destroying file factory", (Throwable)e);
        }
    }
}

