/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorAdd;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;

public class HTTPAcceptorRemove
extends AbstractRemoveStepHandler {
    static final HTTPAcceptorRemove INSTANCE = new HTTPAcceptorRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String acceptorName = context.getCurrentAddressValue();
        String serverName = context.getCurrentAddress().getParent().getLastElement().getValue();
        context.removeService(MessagingServices.getHttpUpgradeServiceName(serverName, acceptorName));
        boolean upgradeLegacy = HTTPAcceptorDefinition.UPGRADE_LEGACY.resolveModelAttribute(context, model).asBoolean();
        if (upgradeLegacy) {
            context.removeService(MessagingServices.getLegacyHttpUpgradeServiceName(serverName, acceptorName));
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String acceptorName = context.getCurrentAddressValue();
        String serverName = context.getCurrentAddress().getParent().getLastElement().getValue();
        HTTPAcceptorAdd.INSTANCE.launchServices(context, serverName, acceptorName, model);
    }
}

