/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.ReportAttacher;
import org.jboss.dmr.ModelNode;

class XMLReportAttacher
extends ReportAttacher.AbstractReportAttacher {
    private XMLStreamWriter streamWriter = null;
    private final AttributeDefinition attributeDefinition;
    private final ByteArrayOutputStream buffer;

    XMLReportAttacher(AttributeDefinition attributeDefinition, boolean record, String namespaceURI, String rootNode) throws OperationFailedException {
        super(record);
        this.attributeDefinition = attributeDefinition;
        this.buffer = new ByteArrayOutputStream();
        if (record) {
            try {
                this.streamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(this.buffer, "UTF-8");
                this.streamWriter.writeStartDocument();
                this.streamWriter.writeStartElement(rootNode);
                this.streamWriter.writeDefaultNamespace(namespaceURI);
            }
            catch (XMLStreamException ex) {
                throw ControllerLogger.MGMT_OP_LOGGER.failedToBuildReport(ex);
            }
        }
    }

    @Override
    public void addReport(ModelNode report) throws OperationFailedException {
        if (this.record && this.streamWriter != null) {
            try {
                this.attributeDefinition.marshallAsElement(report, true, this.streamWriter);
            }
            catch (XMLStreamException ex) {
                throw ControllerLogger.MGMT_OP_LOGGER.failedToBuildReport(ex);
            }
        }
    }

    @Override
    public InputStream getContent() {
        if (this.record && this.streamWriter != null) {
            try {
                this.streamWriter.writeEndElement();
                this.streamWriter.writeEndDocument();
                this.streamWriter.flush();
                return new ByteArrayInputStream(this.buffer.toByteArray());
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(XMLReportAttacher.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new ByteArrayInputStream(EMPTY);
    }

    @Override
    protected String getMimeType() {
        return "application/xml";
    }
}

