/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.SecurityActions;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

public final class FallbackMethodCandidates {
    private final Method withoutExceptionParam;
    private final Map<Class<?>, Method> withExceptionParam;

    private FallbackMethodCandidates(Method withoutExceptionParam, Set<Method> withExceptionParam) {
        this.withoutExceptionParam = withoutExceptionParam;
        HashMap map = new HashMap();
        for (Method method : withExceptionParam) {
            map.put(method.getParameterTypes()[method.getParameterCount() - 1], method);
        }
        this.withExceptionParam = map;
    }

    public boolean isEmpty() {
        return this.withoutExceptionParam == null && this.withExceptionParam.isEmpty();
    }

    public Method select(Class<? extends Throwable> exceptionType) {
        if (!this.withExceptionParam.isEmpty()) {
            for (Class<? extends Throwable> type = exceptionType; type != null; type = type.getSuperclass()) {
                Method candidate = this.withExceptionParam.get(type);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return this.withoutExceptionParam;
    }

    public static FallbackMethodCandidates create(InterceptionPoint point, String fallbackMethodName, boolean allowExceptionParam) {
        try {
            Method guardedMethod = point.method();
            Method withoutExceptionParam = SecurityActions.findFallbackMethod(point.beanClass(), guardedMethod.getDeclaringClass(), fallbackMethodName, guardedMethod.getGenericParameterTypes(), guardedMethod.getGenericReturnType());
            if (withoutExceptionParam != null) {
                SecurityActions.setAccessible(withoutExceptionParam);
            }
            Set<Method> withExceptionParam = Collections.emptySet();
            if (allowExceptionParam) {
                withExceptionParam = SecurityActions.findFallbackMethodsWithExceptionParammeter(point.beanClass(), guardedMethod.getDeclaringClass(), fallbackMethodName, guardedMethod.getGenericParameterTypes(), guardedMethod.getGenericReturnType());
                for (Method method : withExceptionParam) {
                    SecurityActions.setAccessible(method);
                }
            }
            return new FallbackMethodCandidates(withoutExceptionParam, withExceptionParam);
        }
        catch (PrivilegedActionException e) {
            throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName, (Throwable)e);
        }
    }
}

