/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.handlers.HandlerAdd;
import org.wildfly.extension.undertow.handlers.HandlerFactory;

abstract class HandlerDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.undertow.handler", (boolean)true, HttpHandler.class).build();
    private final HandlerFactory factory;

    protected HandlerDefinition(PathElement path, HandlerFactory factory) {
        super(new SimpleResourceDefinition.Parameters(path, (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", path.getKey())));
        this.factory = factory;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        HandlerAdd add = new HandlerAdd(this.factory, this.getAttributes());
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(UndertowService.HANDLER, (AbstractAddStepHandler)add), new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(CAPABILITY);
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return List.of(new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "undertow-handler", false, false, false)));
    }
}

