/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.at;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.PersistableParticipant;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLStreamException;
import org.jboss.jbossts.xts.recovery.participant.at.ATParticipantHelper;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryModule;

public abstract class ATParticipantRecoveryRecord
implements PersistableParticipant {
    protected Durable2PCParticipant participant;
    protected String id;
    private boolean useSerialization;
    private byte[] recoveryState;
    private boolean recoveryStateValid;
    private static final String type = "/XTS/WSAT/ParticipantRecoveryRecord";

    protected ATParticipantRecoveryRecord(String id, Durable2PCParticipant participant) {
        this.id = id;
        this.participant = participant;
        this.recoveryState = null;
        this.recoveryStateValid = false;
    }

    @Override
    public final boolean saveState(OutputObjectState oos) {
        if (this.participant == null) {
            return false;
        }
        try {
            this.useSerialization = ATParticipantHelper.isSerializable(this.participant);
            this.recoveryState = ATParticipantHelper.getRecoveryState(this.useSerialization, this.participant);
            this.recoveryStateValid = true;
        }
        catch (Exception exception) {
            WSTLogger.i18NLogger.warn_recovery_participant_at_ATParticipantRecoveryRecord_saveState_1(this.id, exception);
            this.recoveryStateValid = false;
        }
        try {
            oos.packString(this.id);
            this.saveEndpointReference(oos);
            oos.packBoolean(this.recoveryStateValid);
            if (this.recoveryStateValid) {
                oos.packBoolean(this.useSerialization);
                if (this.recoveryState != null) {
                    oos.packBoolean(true);
                    oos.packBytes(this.recoveryState);
                } else {
                    oos.packBoolean(false);
                }
            }
        }
        catch (XMLStreamException xmle) {
            WSTLogger.i18NLogger.warn_recovery_participant_at_ATParticipantRecoveryRecord_saveState_2(this.id, xmle);
            return false;
        }
        catch (IOException ioe) {
            WSTLogger.i18NLogger.warn_recovery_participant_at_ATParticipantRecoveryRecord_saveState_3(this.id, ioe);
            return false;
        }
        return true;
    }

    @Override
    public boolean restoreState(InputObjectState ios) {
        try {
            this.id = ios.unpackString();
            this.restoreEndpointReference(ios);
            this.recoveryStateValid = ios.unpackBoolean();
            if (this.recoveryStateValid) {
                this.useSerialization = ios.unpackBoolean();
                this.recoveryState = (byte[])(ios.unpackBoolean() ? ios.unpackBytes() : null);
            }
        }
        catch (XMLStreamException xmle) {
            WSTLogger.i18NLogger.warn_recovery_participant_at_ATParticipantRecoveryRecord_restoreState_1(this.id, xmle);
            return false;
        }
        catch (IOException ioe) {
            WSTLogger.i18NLogger.warn_recovery_participant_at_ATParticipantRecoveryRecord_restoreState_2(this.id, ioe);
            return false;
        }
        return true;
    }

    public boolean restoreParticipant(XTSATRecoveryModule module) throws Exception {
        if (this.participant != null) {
            return false;
        }
        if (this.recoveryStateValid) {
            if (this.useSerialization) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recoveryState);
                ObjectInputStream ois = new ObjectInputStream(bais);
                this.participant = module.deserialize(this.getId(), ois);
            } else {
                this.participant = module.recreate(this.getId(), this.recoveryState);
            }
            return this.participant != null;
        }
        String mesg = WSTLogger.i18NLogger.get_recovery_participant_at_ATParticipantRecoveryRecord_restoreParticipant_1(this.id);
        throw new Exception(mesg);
    }

    public String getId() {
        return this.id;
    }

    public static String type() {
        return type;
    }

    protected abstract void saveEndpointReference(OutputObjectState var1) throws IOException, XMLStreamException;

    protected abstract void restoreEndpointReference(InputObjectState var1) throws IOException, XMLStreamException;

    public abstract void activate();

    public abstract boolean isActive();
}

