/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.AttributeParsers;
import org.wildfly.extension.batch.jberet.BatchSubsystemParser_2_0;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet.job.repository.CommonAttributes;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

class BatchSubsystemParser_3_0
extends BatchSubsystemParser_2_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    @Override
    protected void parseJobRepository(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> ops) throws XMLStreamException {
        Map<Attribute, String> topLevelAttributes = AttributeParsers.readAttributes(reader, EnumSet.of(Attribute.NAME, Attribute.EXECUTION_RECORDS_LIMIT));
        String name = topLevelAttributes.get((Object)Attribute.NAME);
        String executionRecordsLimit = topLevelAttributes.get((Object)Attribute.EXECUTION_RECORDS_LIMIT);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName()});
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress.append("in-memory-job-repository", name));
                if (executionRecordsLimit != null) {
                    CommonAttributes.EXECUTION_RECORDS_LIMIT.parseAndSetParameter(executionRecordsLimit, op, (XMLStreamReader)reader);
                }
                ops.add(op);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            if (element == Element.JDBC) {
                Map<Attribute, String> attributes = AttributeParsers.readRequiredAttributes(reader, EnumSet.of(Attribute.DATA_SOURCE));
                ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress.append("jdbc-job-repository", name));
                JdbcJobRepositoryDefinition.DATA_SOURCE.parseAndSetParameter(attributes.get((Object)Attribute.DATA_SOURCE), op, (XMLStreamReader)reader);
                if (executionRecordsLimit != null) {
                    CommonAttributes.EXECUTION_RECORDS_LIMIT.parseAndSetParameter(executionRecordsLimit, op, (XMLStreamReader)reader);
                }
                ops.add(op);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

