/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public final class EEModuleConfiguration {
    private final String applicationName;
    private final String moduleName;
    private final List<ComponentConfiguration> componentConfigurations;

    public EEModuleConfiguration(EEModuleDescription description) throws DeploymentUnitProcessingException {
        this.applicationName = description.getApplicationName();
        this.moduleName = description.getModuleName();
        this.componentConfigurations = new ArrayList<ComponentConfiguration>();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Collection<ComponentConfiguration> getComponentConfigurations() {
        return Collections.unmodifiableList(this.componentConfigurations);
    }

    public void addComponentConfiguration(ComponentConfiguration configuration) {
        this.componentConfigurations.add(configuration);
    }
}

