/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.ManagedExecutorServiceImpl;
import org.jboss.as.ee.concurrent.ManagedScheduledExecutorServiceImpl;

class ManagedExecutorRuntimeStatsImpl
implements ManagedExecutorRuntimeStats {
    private final AbstractManagedExecutorService abstractManagedExecutorService;
    private final ThreadPoolExecutor threadPoolExecutor;

    ManagedExecutorRuntimeStatsImpl(ManagedExecutorServiceImpl executorService) {
        this.abstractManagedExecutorService = executorService;
        this.threadPoolExecutor = executorService.getThreadPoolExecutor();
    }

    ManagedExecutorRuntimeStatsImpl(ManagedScheduledExecutorServiceImpl executorService) {
        this.abstractManagedExecutorService = executorService;
        this.threadPoolExecutor = executorService.getThreadPoolExecutor();
    }

    @Override
    public int getThreadsCount() {
        return this.threadPoolExecutor.getPoolSize();
    }

    @Override
    public int getActiveThreadsCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    @Override
    public int getMaxThreadsCount() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    @Override
    public int getHungThreadsCount() {
        Collection hungThreads = this.abstractManagedExecutorService.getHungThreads();
        return hungThreads != null ? hungThreads.size() : 0;
    }

    @Override
    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }

    @Override
    public int getQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }
}

