/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.ControlPointUtils;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStatsImpl;
import org.jboss.as.ee.concurrent.ManagedExecutorWithHungThreads;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class ManagedExecutorServiceImpl
extends org.glassfish.enterprise.concurrent.ManagedExecutorServiceImpl
implements ManagedExecutorWithHungThreads {
    private final ControlPoint controlPoint;
    private final ManagedExecutorRuntimeStats runtimeStats;

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, BlockingQueue<Runnable> queue, ControlPoint controlPoint) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, contextService, rejectPolicy, queue);
        this.controlPoint = controlPoint;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl(this);
    }

    public ManagedExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, ControlPoint controlPoint) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, corePoolSize, maxPoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, queueCapacity, contextService, rejectPolicy);
        this.controlPoint = controlPoint;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl(this);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Callable<T> callable = ControlPointUtils.doWrap(task, this.controlPoint);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap(callable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public <T> Future<T> submit(Runnable task, T result) {
        Runnable runnable = ControlPointUtils.doWrap(task, this.controlPoint);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap(runnable), result);
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public Future<?> submit(Runnable task) {
        Runnable runnable = ControlPointUtils.doWrap(task, this.controlPoint);
        try {
            return super.submit(SecurityIdentityUtils.doIdentityWrap(runnable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    public void execute(Runnable command) {
        Runnable runnable = ControlPointUtils.doWrap(command, this.controlPoint);
        try {
            super.execute(SecurityIdentityUtils.doIdentityWrap(runnable));
        }
        catch (Exception e) {
            this.controlPoint.requestComplete();
            throw e;
        }
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)super.getThreadPoolExecutor();
    }

    public ManagedExecutorRuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }
}

