/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.realm.FileSystemRealmUtil;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.PropertiesCredentialStore;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;

class FileSystemEncryptRealmCommand
extends Command {
    static final int GENERAL_CONFIGURATION_WARNING = 1;
    static final String FILE_SYSTEM_ENCRYPT_COMMAND = "filesystem-realm-encrypt";
    static final int SUMMARY_WIDTH = 100;
    private static final String HELP_PARAM = "help";
    private static final String DEBUG_PARAM = "debug";
    private static final String SILENT_PARAM = "silent";
    private static final String SUMMARY_PARAM = "summary";
    private static final String INPUT_REALM_LOCATION_PARAM = "input-location";
    private static final String REALM_NAME_PARAM = "realm-name";
    private static final String OUTPUT_REALM_LOCATION_PARAM = "output-location";
    private static final String CREDENTIAL_STORE_LOCATION_PARAM = "credential-store";
    private static final String CREATE_CREDENTIAL_STORE_PARAM = "create";
    private static final String SECRET_KEY_ALIAS_PARAM = "secret-key";
    private static final String HASH_ENCODING_PARAM = "hash-encoding";
    private static final String ENCODED_PARAM = "encoded";
    private static final String LEVELS_PARAM = "levels";
    private static final String POPULATE_SECRET_KEY_PARAM = "populate";
    private static final String BULK_CONVERT_PARAM = "bulk-convert";
    private static final String FILE_ARG = "file";
    private static final String DIRECTORY_ARG = "directory";
    private static final String NAME_ARG = "name";
    private static final String DEFAULT_FILESYSTEM_REALM_NAME = "encrypted-filesystem-realm";
    public static Supplier<Provider[]> ELYTRON_PASSWORD_PROVIDERS = () -> new Provider[]{WildFlyElytronPasswordProvider.getInstance()};
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final List<String> PARAMS_LIST = new ArrayList<String>(Arrays.asList("input-location", "output-location"));
    private final Options options;
    private final CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;
    private boolean silentMode = false;
    private boolean summaryMode = false;
    private StringBuilder summaryString = null;
    private boolean warningOccurred = false;

    FileSystemEncryptRealmCommand() {
        this.options = new Options();
        Option option = new Option("i", INPUT_REALM_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptInputLocationDesc());
        option.setArgName(DIRECTORY_ARG);
        this.options.addOption(option);
        option = new Option("r", REALM_NAME_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptNewRealmDesc());
        option.setArgName(DIRECTORY_ARG);
        this.options.addOption(option);
        option = new Option("o", OUTPUT_REALM_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptOutputLocationDesc());
        option.setArgName(DIRECTORY_ARG);
        this.options.addOption(option);
        option = new Option("c", CREDENTIAL_STORE_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptCredentialStoreDesc());
        option.setArgName(FILE_ARG);
        this.options.addOption(option);
        option = new Option("a", CREATE_CREDENTIAL_STORE_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptCreateCredentialStoreDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("s", SECRET_KEY_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptSecretKeyDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("e", HASH_ENCODING_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptHashEncodingDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("f", ENCODED_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptEncodedDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("l", LEVELS_PARAM, true, ElytronToolMessages.msg.cmdFileSystemEncryptLevelsDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("p", POPULATE_SECRET_KEY_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmEncryptPopulateDesc());
        option.setArgName(NAME_ARG);
        this.options.addOption(option);
        option = new Option("b", BULK_CONVERT_PARAM, true, ElytronToolMessages.msg.cmdFileSystemRealmEncryptBulkConvertDesc());
        option.setArgName(FILE_ARG);
        this.options.addOption(option);
        option = Option.builder().longOpt(HELP_PARAM).desc(ElytronToolMessages.msg.cmdLineHelp()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(DEBUG_PARAM).desc(ElytronToolMessages.msg.cmdLineDebug()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(SILENT_PARAM).desc(ElytronToolMessages.msg.cmdFileSystemRealmSilentDesc()).build();
        this.options.addOption(option);
        option = Option.builder().longOpt(SUMMARY_PARAM).desc(ElytronToolMessages.msg.cmdFileSystemRealmSummaryDesc()).build();
        this.options.addOption(option);
    }

    @Override
    public void execute(String[] args) throws Exception {
        this.setStatus(7);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption(DEBUG_PARAM));
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        if (this.cmdLine.hasOption(SILENT_PARAM)) {
            this.silentMode = true;
        }
        if (this.cmdLine.hasOption(SUMMARY_PARAM)) {
            this.summaryMode = true;
            this.summaryString = new StringBuilder();
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append("Summary for execution of Elytron-Tool command FileSystemRealmEncrypt");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
        }
        this.printDuplicatesWarning(this.cmdLine);
        String realmNameOption = this.cmdLine.getOptionValue("r");
        String inputRealmLocationOption = this.cmdLine.getOptionValue("i");
        String outputRealmLocationOption = this.cmdLine.getOptionValue("o");
        String credentialStoreOption = this.cmdLine.getOptionValue("c");
        String createCredentialStore = this.cmdLine.getOptionValue("a");
        String secretKeyAliasOption = this.cmdLine.getOptionValue("s");
        String hashEncodingOption = this.cmdLine.getOptionValue("e");
        String levelsOption = this.cmdLine.getOptionValue("l");
        String encodedOption = this.cmdLine.getOptionValue("f");
        String bulkConvert = this.cmdLine.getOptionValue("b");
        String populateOption = this.cmdLine.getOptionValue("p");
        if (bulkConvert == null) {
            if (realmNameOption == null) {
                realmNameOption = DEFAULT_FILESYSTEM_REALM_NAME;
            }
            Descriptor descriptor = new Descriptor();
            descriptor.setFileSystemRealmName(realmNameOption);
            if (outputRealmLocationOption == null) {
                this.errorHandler((Exception)ElytronToolMessages.msg.outputLocationNotSpecified());
            } else {
                File outputPath = new File(outputRealmLocationOption);
                if (!outputPath.exists()) {
                    outputPath.mkdirs();
                }
                descriptor.setOutputRealmLocation(Paths.get(outputRealmLocationOption, new String[0]).toString());
            }
            if (inputRealmLocationOption == null) {
                this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationNotSpecified());
            } else {
                Path inputPath = Paths.get(inputRealmLocationOption, new String[0]);
                descriptor.setInputRealmLocation(inputPath.toString());
                if (Files.notExists(inputPath, new LinkOption[0])) {
                    this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationDoesNotExist());
                }
            }
            if (hashEncodingOption == null) {
                descriptor.setHashEncoding(Encoding.BASE64);
            } else {
                try {
                    descriptor.setHashEncoding(Encoding.valueOf((String)hashEncodingOption.toUpperCase()));
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    this.errorHandler(e);
                }
            }
            if (populateOption == null) {
                descriptor.setPopulate(true);
            } else {
                descriptor.setPopulate(Boolean.valueOf(populateOption));
            }
            if (levelsOption == null) {
                descriptor.setLevels(2);
            } else {
                try {
                    descriptor.setLevels(Integer.parseInt(levelsOption));
                }
                catch (NumberFormatException e) {
                    this.errorHandler(e);
                }
            }
            if (encodedOption == null) {
                descriptor.setEncoded(true);
            } else {
                try {
                    descriptor.setEncoded(Boolean.parseBoolean(encodedOption));
                }
                catch (IllegalArgumentException e) {
                    this.errorHandler(e);
                }
            }
            if (createCredentialStore != null) {
                descriptor.setCreateCredentialStore(Boolean.valueOf(createCredentialStore));
            } else {
                descriptor.setCreateCredentialStore(true);
            }
            if (credentialStoreOption != null) {
                descriptor.setCredentialStore(credentialStoreOption);
            } else {
                this.errorHandler((Exception)ElytronToolMessages.msg.credentialStoreDoesNotExist());
            }
            if (secretKeyAliasOption != null) {
                descriptor.setSecretKeyAlias(secretKeyAliasOption);
            } else {
                descriptor.setSecretKeyAlias("key");
            }
            this.descriptors.add(descriptor);
            this.checkDescriptorFields(descriptor);
        } else {
            if (inputRealmLocationOption != null || outputRealmLocationOption != null || secretKeyAliasOption != null || realmNameOption != null || credentialStoreOption != null || createCredentialStore != null || hashEncodingOption != null || encodedOption != null || levelsOption != null || populateOption != null) {
                throw ElytronToolMessages.msg.mutuallyExclusiveOptionsEncryptSpecified();
            }
            if (this.summaryMode) {
                this.summaryString.append(String.format("Options were specified via descriptor file: %s, converting multiple old filesystem realm", bulkConvert));
                this.summaryString.append(System.getProperty("line.separator"));
            }
            this.parseDescriptorFile(bulkConvert);
        }
        this.createFileSystemRealm();
        this.createWildFlyScript();
        if (this.summaryMode) {
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append("End of summary");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(String.join((CharSequence)"", Collections.nCopies(100, "-")));
            System.out.println(this.summaryString);
        }
        if (this.warningOccurred) {
            this.setStatus(1);
        } else {
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        }
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(1024);
        help.printHelp(ElytronToolMessages.msg.cmdHelp(this.getToolCommand(), FILE_SYSTEM_ENCRYPT_COMMAND), ElytronToolMessages.msg.cmdFileSystemEncryptHelpHeader(), this.options, "", true);
    }

    private void warningHandler(String warning) {
        this.warningOccurred = true;
        if (!this.silentMode) {
            System.out.print("WARNING: ");
            System.out.println(warning);
        }
        if (this.summaryMode) {
            this.summaryString.append("WARNING: ");
            this.summaryString.append(warning);
            this.summaryString.append(System.getProperty("line.separator"));
        }
    }

    private void errorHandler(Exception e) throws Exception {
        this.setStatus(7);
        if (this.summaryMode) {
            this.summaryString.append("Error was thrown during execution:");
            this.summaryString.append(System.getProperty("line.separator"));
            this.summaryString.append(e.getMessage());
            System.out.println(System.getProperty("line.separator") + this.summaryString.toString());
        }
        throw e;
    }

    private void printDescriptorBlocks(int count) {
        this.summaryString.append(System.getProperty("line.separator"));
        this.summaryString.append(System.getProperty("line.separator"));
        this.summaryString.append("Found following unencrypted filesystem-realm combinations, null indicates missing required component:");
        this.summaryString.append(System.getProperty("line.separator"));
        for (int i = 0; i < count; ++i) {
            StringBuilder summary = new StringBuilder();
            summary.append("\tPrinting summary for block ");
            summary.append(i + 1);
            summary.append(System.getProperty("line.separator"));
            Descriptor descriptor = this.descriptors.get(i);
            for (String param : this.PARAMS_LIST) {
                summary.append("\t\t");
                summary.append(param);
                summary.append(" - ");
                summary.append(this.getDescriptorParam(param, descriptor));
                summary.append(System.getProperty("line.separator"));
            }
            this.summaryString.append((CharSequence)summary);
        }
        this.summaryString.append(System.getProperty("line.separator"));
    }

    private String getDescriptorParam(String param, Descriptor descriptor) {
        switch (param) {
            case "input-location": {
                return descriptor.getInputRealmLocation();
            }
            case "output-location": {
                return descriptor.getOutputRealmLocation();
            }
            case "realm-name": {
                return descriptor.getFileSystemRealmName();
            }
            case "credential-store": {
                return descriptor.getCredentialStore();
            }
            case "secret-key": {
                return descriptor.getSecretKeyAlias();
            }
        }
        return null;
    }

    private void parseDescriptorFile(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        if (!path.toFile().exists()) {
            this.errorHandler(ElytronToolMessages.msg.fileNotFound(file));
        }
        Descriptor descriptor = new Descriptor();
        AtomicInteger count = new AtomicInteger(1);
        try (Stream<String> stream = Files.lines(path);){
            stream.forEach(line -> {
                if (line.equals("")) {
                    this.findMissingRequiredValuesAndSetValues(count.intValue(), descriptor);
                    this.copyAddResetDescriptor(descriptor);
                    count.getAndIncrement();
                } else {
                    String[] parts = line.split(":");
                    String option = parts[0];
                    String arg = parts[1];
                    switch (option) {
                        case "input-location": {
                            descriptor.setInputRealmLocation(arg);
                            break;
                        }
                        case "output-location": {
                            descriptor.setOutputRealmLocation(arg);
                            break;
                        }
                        case "realm-name": {
                            descriptor.setFileSystemRealmName(arg);
                            break;
                        }
                        case "credential-store": {
                            descriptor.setCredentialStore(arg);
                            break;
                        }
                        case "secret-key": {
                            descriptor.setSecretKeyAlias(arg);
                            break;
                        }
                        case "create": {
                            descriptor.setCreateCredentialStore(Boolean.parseBoolean(arg));
                            break;
                        }
                        case "hash-encoding": {
                            descriptor.setHashEncoding(Encoding.valueOf((String)arg.toUpperCase()));
                            break;
                        }
                        case "encoded": {
                            descriptor.setEncoded(Boolean.parseBoolean(arg));
                            break;
                        }
                        case "levels": {
                            descriptor.setLevels(Integer.parseInt(arg));
                            break;
                        }
                        case "populate": {
                            descriptor.setPopulate(Boolean.parseBoolean(arg));
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            this.errorHandler(e);
        }
        int currentCount = count.intValue();
        this.findMissingRequiredValuesAndSetValues(currentCount, descriptor);
        this.copyAddResetDescriptor(descriptor);
        if (this.summaryMode) {
            this.printDescriptorBlocks(currentCount);
        }
        count.getAndIncrement();
    }

    private void copyAddResetDescriptor(Descriptor original) {
        Descriptor temp = new Descriptor(original);
        this.descriptors.add(temp);
        original.reset();
    }

    private void findMissingRequiredValuesAndSetValues(int count, Descriptor descriptor) {
        boolean missingRequiredValue = false;
        if (descriptor.getInputRealmLocation() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInputLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getOutputRealmLocation() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockOutputLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getFileSystemRealmName() == null) {
            descriptor.setFileSystemRealmName(DEFAULT_FILESYSTEM_REALM_NAME);
        }
        if (descriptor.getHashEncoding() == null) {
            descriptor.setHashEncoding(Encoding.BASE64);
        }
        if (descriptor.getEncoded() == null) {
            descriptor.setEncoded(true);
        }
        if (descriptor.getLevels() == null) {
            descriptor.setLevels(2);
        }
        if (descriptor.getCredentialStore() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockCredentialStoreLocation(count));
            missingRequiredValue = true;
        }
        if (descriptor.getCreateCredentialStore() == null) {
            descriptor.setCreateCredentialStore(true);
        }
        if (descriptor.getPopulate() == null) {
            descriptor.setPopulate(true);
        }
        if (descriptor.getSecretKeyAlias() == null) {
            descriptor.setSecretKeyAlias("key");
        }
        if (missingRequiredValue) {
            descriptor.reset();
        }
    }

    private void createFileSystemRealm() throws Exception {
        for (Descriptor descriptor : this.descriptors) {
            SecretKey key;
            CredentialStore credentialStore;
            System.out.println(ElytronToolMessages.msg.fileSystemRealmEncryptCreatingRealm(descriptor.getInputRealmLocation()));
            if (this.checkDescriptorFields(descriptor)) continue;
            String csType = PropertiesCredentialStore.NAME;
            try {
                credentialStore = CredentialStore.getInstance((String)csType);
            }
            catch (NoSuchAlgorithmException e) {
                credentialStore = CredentialStore.getInstance((String)csType, this.getProvidersSupplier(null));
            }
            HashMap<String, String> implProps = new HashMap<String, String>();
            implProps.put(CREATE_CREDENTIAL_STORE_PARAM, String.valueOf(descriptor.getCreateCredentialStore()));
            implProps.put("location", descriptor.getCredentialStore());
            implProps.put("modifiable", Boolean.TRUE.toString());
            credentialStore.initialize(implProps);
            try {
                ((SecretKeyCredential)credentialStore.retrieve(descriptor.getSecretKeyAlias(), SecretKeyCredential.class)).getSecretKey();
                System.out.println(ElytronToolMessages.msg.existingCredentialStore());
            }
            catch (Exception e) {
                if (!descriptor.getCreateCredentialStore().booleanValue()) {
                    this.warningHandler(ElytronToolMessages.msg.skippingBlockMissingCredentialStore());
                    continue;
                }
                if (descriptor.getPopulate().booleanValue()) {
                    SecretKey key2 = SecretKeyUtil.generateSecretKey((int)256);
                    SecretKeyCredential keyCredential = new SecretKeyCredential(key2);
                    credentialStore.store(descriptor.getSecretKeyAlias(), (Credential)keyCredential);
                    credentialStore.flush();
                }
                this.errorHandler((Exception)ElytronToolMessages.msg.cmdFileSystemPopulateUnspecified());
            }
            try {
                key = ((SecretKeyCredential)credentialStore.retrieve(descriptor.getSecretKeyAlias(), SecretKeyCredential.class)).getSecretKey();
            }
            catch (NullPointerException e) {
                System.out.println(ElytronToolMessages.msg.cmdFileSystemEncryptionNoSecretKey(descriptor.getCredentialStore(), descriptor.getInputRealmLocation()));
                continue;
            }
            FileSystemSecurityRealm oldFileSystemRealm = FileSystemSecurityRealm.builder().setRoot(Paths.get(descriptor.getInputRealmLocation(), new String[0])).setLevels(descriptor.getLevels().intValue()).setHashEncoding(descriptor.getHashEncoding()).setEncoded(descriptor.getEncoded().booleanValue()).setProviders(ELYTRON_PASSWORD_PROVIDERS).build();
            FileSystemSecurityRealm newFileSystemRealm = FileSystemSecurityRealm.builder().setRoot(Paths.get(descriptor.getOutputRealmLocation(), descriptor.getFileSystemRealmName())).setSecretKey(key).setLevels(descriptor.getLevels().intValue()).setProviders(ELYTRON_PASSWORD_PROVIDERS).build();
            FileSystemRealmUtil.createEncryptedRealmFromUnencrypted((FileSystemSecurityRealm)oldFileSystemRealm, (FileSystemSecurityRealm)newFileSystemRealm);
        }
    }

    private void createWildFlyScript() throws Exception {
        int counter = 0;
        for (Descriptor descriptor : this.descriptors) {
            if (this.checkDescriptorFields(descriptor)) continue;
            String outputRealmLocation = descriptor.getOutputRealmLocation();
            String fileSystemRealmName = descriptor.getFileSystemRealmName();
            String credentialStore = descriptor.getCredentialStore();
            String secretKeyAlias = descriptor.getSecretKeyAlias();
            int levels = descriptor.getLevels();
            if (secretKeyAlias == null) {
                secretKeyAlias = "key";
            }
            String createScriptCheck = "";
            if (Paths.get(String.format("%s.cli", fileSystemRealmName), new String[0]).toFile().exists()) {
                createScriptCheck = this.prompt(false, null, false, ElytronToolMessages.msg.shouldFileBeOverwritten(String.format("%s.cli", fileSystemRealmName)));
            }
            String fullOutputPath = outputRealmLocation.startsWith(".") ? Paths.get(outputRealmLocation.substring(2), new String[0]).toAbsolutePath().toString() : Paths.get(outputRealmLocation, new String[0]).toAbsolutePath().toString();
            if (this.summaryMode) {
                this.summaryString.append(String.format("Configured script for WildFly named %s.cli at %s.", fileSystemRealmName, fullOutputPath));
                this.summaryString.append(System.getProperty("line.separator"));
                this.summaryString.append("The script is using the following names:");
                this.summaryString.append(System.getProperty("line.separator"));
                this.summaryString.append(String.format("Name of filesystem-realm: %s", fileSystemRealmName));
                this.summaryString.append(System.getProperty("line.separator"));
            }
            List<String> scriptLines = Arrays.asList(String.format("/subsystem=elytron/secret-key-credential-store=%s:add(path=%s)", "mycredstore" + counter, credentialStore), String.format("/subsystem=elytron/filesystem-realm=%s:add(path=%s, levels=%s, credential-store=%s, secret-key=%s)", fileSystemRealmName, fullOutputPath + '/' + fileSystemRealmName, levels, "mycredstore" + counter, secretKeyAlias));
            if (!createScriptCheck.equals("y") && !createScriptCheck.equals("yes")) {
                Files.write(Paths.get(String.format("%s/%s.cli", outputRealmLocation, fileSystemRealmName), new String[0]), scriptLines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            } else {
                Files.write(Paths.get(String.format("%s/%s.cli", outputRealmLocation, fileSystemRealmName), new String[0]), scriptLines, StandardOpenOption.APPEND);
            }
            ++counter;
        }
    }

    private boolean checkDescriptorFields(Descriptor descriptor) {
        if (descriptor.getInputRealmLocation() == null || descriptor.getOutputRealmLocation() == null || descriptor.getFileSystemRealmName() == null || descriptor.getCredentialStore() == null || descriptor.getCreateCredentialStore() == null || descriptor.getSecretKeyAlias() == null || descriptor.getHashEncoding() == null || descriptor.getEncoded() == null || descriptor.getLevels() == null || descriptor.getPopulate() == null) {
            this.warningHandler(ElytronToolMessages.msg.fileSystemEncryptRequiredParametersNotSpecified());
            return true;
        }
        return false;
    }

    private static final class Descriptor {
        private String inputRealmLocation;
        private String outputRealmLocation;
        private String fileSystemRealmName;
        private String credentialStore;
        private String secretKeyAlias;
        private Integer levels;
        private Encoding hashEncoding;
        private Boolean encoded;
        private Boolean createCredentialStore;
        private Boolean populate;

        Descriptor() {
        }

        Descriptor(Descriptor descriptor) {
            this.inputRealmLocation = descriptor.inputRealmLocation;
            this.outputRealmLocation = descriptor.outputRealmLocation;
            this.fileSystemRealmName = descriptor.fileSystemRealmName;
            this.credentialStore = descriptor.credentialStore;
            this.hashEncoding = descriptor.hashEncoding;
            this.levels = descriptor.levels;
            this.encoded = descriptor.encoded;
            this.createCredentialStore = descriptor.createCredentialStore;
            this.secretKeyAlias = descriptor.secretKeyAlias;
            this.populate = descriptor.populate;
        }

        public Encoding getHashEncoding() {
            return this.hashEncoding;
        }

        public void setHashEncoding(Encoding hashEncoding) {
            this.hashEncoding = hashEncoding;
        }

        public Integer getLevels() {
            return this.levels;
        }

        public void setLevels(Integer levels) {
            this.levels = levels;
        }

        public String getInputRealmLocation() {
            return this.inputRealmLocation;
        }

        public void setInputRealmLocation(String inputRealmLocation) {
            this.inputRealmLocation = inputRealmLocation;
        }

        public String getOutputRealmLocation() {
            return this.outputRealmLocation;
        }

        public void setOutputRealmLocation(String outputRealmLocation) {
            this.outputRealmLocation = outputRealmLocation;
        }

        public String getFileSystemRealmName() {
            return this.fileSystemRealmName;
        }

        public void setFileSystemRealmName(String fileSystemRealmName) {
            this.fileSystemRealmName = fileSystemRealmName;
        }

        public Boolean getEncoded() {
            return this.encoded;
        }

        public void setEncoded(boolean encoded) {
            this.encoded = encoded;
        }

        String getCredentialStore() {
            return this.credentialStore;
        }

        void setCredentialStore(String credentialStore) {
            this.credentialStore = credentialStore;
        }

        Boolean getCreateCredentialStore() {
            return this.createCredentialStore;
        }

        void setCreateCredentialStore(Boolean createCredentialStore) {
            this.createCredentialStore = createCredentialStore;
        }

        String getSecretKeyAlias() {
            return this.secretKeyAlias;
        }

        void setSecretKeyAlias(String secretKeyAlias) {
            this.secretKeyAlias = secretKeyAlias;
        }

        Boolean getPopulate() {
            return this.populate;
        }

        void setPopulate(Boolean populate) {
            this.populate = populate;
        }

        void reset() {
            this.inputRealmLocation = null;
            this.outputRealmLocation = null;
            this.fileSystemRealmName = null;
            this.credentialStore = null;
            this.createCredentialStore = null;
            this.secretKeyAlias = null;
            this.hashEncoding = null;
            this.encoded = null;
            this.levels = null;
            this.populate = null;
        }
    }
}

