/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge;

import java.io.Serializable;
import java.util.Locale;
import javax.management.ObjectName;
import org.apache.activemq.artemis.jms.bridge.ActiveMQJMSBridgeLogger;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class ActiveMQJMSBridgeLogger_$logger
extends DelegatingBasicLogger
implements ActiveMQJMSBridgeLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQJMSBridgeLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ActiveMQJMSBridgeLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToSetUpBridge(long failureRetryInterval, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.failedToSetUpBridge$str(), (Object)failureRetryInterval, (Object)bridgeName);
    }

    protected String failedToSetUpBridge$str() {
        return "AMQ341000: Failed to set up JMS bridge {1} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {0} ms";
    }

    @Override
    public final void bridgeReconnected(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeReconnected$str(), (Object)bridgeName);
    }

    protected String bridgeReconnected$str() {
        return "AMQ341001: JMS Bridge {0} succeeded in reconnecting to servers";
    }

    @Override
    public final void bridgeConnected(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeConnected$str(), (Object)bridgeName);
    }

    protected String bridgeConnected$str() {
        return "AMQ341002: JMSBridge {0} succeeded in connecting to servers";
    }

    @Override
    public final void errorBridgeAlreadyStarted(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorBridgeAlreadyStarted$str(), (Object)bridgeName);
    }

    protected String errorBridgeAlreadyStarted$str() {
        return "AMQ342000: Attempt to start JMS Bridge {0}, but is already started";
    }

    @Override
    public final void errorStartingBridge(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorStartingBridge$str(), (Object)bridgeName);
    }

    protected String errorStartingBridge$str() {
        return "AMQ342001: Failed to start JMS Bridge {0}";
    }

    @Override
    public final void errorUnregisteringBridge(ObjectName objectName, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorUnregisteringBridge$str(), (Object)objectName, (Object)bridgeName);
    }

    protected String errorUnregisteringBridge$str() {
        return "AMQ342002: Failed to unregisted JMS Bridge {0} - {1}";
    }

    @Override
    public final void errorConnectingBridge(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorConnectingBridge$str(), (Object)bridgeName);
    }

    protected String errorConnectingBridge$str() {
        return "AMQ342003: JMS Bridge {0} unable to set up connections, bridge will be stopped";
    }

    @Override
    public final void bridgeRetry(long failureRetryInterval, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeRetry$str(), (Object)failureRetryInterval, (Object)bridgeName);
    }

    protected String bridgeRetry$str() {
        return "AMQ342004: JMS Bridge {1}, will retry after a pause of {0} ms";
    }

    @Override
    public final void bridgeNotStarted(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeNotStarted$str(), (Object)bridgeName);
    }

    protected String bridgeNotStarted$str() {
        return "AMQ342005: JMS Bridge {0} unable to set up connections, bridge will not be started";
    }

    @Override
    public final void bridgeFailure(Exception e, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.bridgeFailure$str(), (Object)bridgeName);
    }

    protected String bridgeFailure$str() {
        return "AMQ342006: JMS Bridge {0}, detected failure on bridge connection";
    }

    @Override
    public final void bridgeAckError(Exception e, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.bridgeAckError$str(), (Object)bridgeName);
    }

    protected String bridgeAckError$str() {
        return "AMQ342009: JMS Bridge {0} failed to send + acknowledge batch, closing JMS objects";
    }

    @Override
    public final void bridgeConnectError(Exception e, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.bridgeConnectError$str(), (Object)bridgeName);
    }

    protected String bridgeConnectError$str() {
        return "AMQ342010: Failed to connect JMS Bridge {0}";
    }

    @Override
    public final void transactionRolledBack(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.transactionRolledBack$str(), new Object[0]);
    }

    protected String transactionRolledBack$str() {
        return "AMQ342011: Transaction rolled back, retrying TX";
    }

    @Override
    public final void jmsBridgeSrcConnectError(Exception e, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.jmsBridgeSrcConnectError$str(), (Object)bridgeName);
    }

    protected String jmsBridgeSrcConnectError$str() {
        return "AMQ344001: JMS Bridge {0}, failed to start source connection";
    }

    @Override
    public final void jmsBridgeTransactionManagerMissing(QualityOfServiceMode qosMode, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.jmsBridgeTransactionManagerMissing$str(), (Object)qosMode, (Object)bridgeName);
    }

    protected String jmsBridgeTransactionManagerMissing$str() {
        return "AMQ344002: Failed to start JMS Bridge {1}.  QoS Mode: {0} requires a Transaction Manager, none found";
    }
}

