/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.annotations.Incomings;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.MediatorFactory;
import io.smallrye.reactive.messaging.providers.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.providers.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.providers.extension.CollectedMediatorMetadata;
import io.smallrye.reactive.messaging.providers.extension.HealthCenter;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.wiring.Graph;
import io.smallrye.reactive.messaging.providers.wiring.Wiring;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

@ApplicationScoped
public class MediatorManager {
    public static final String STRICT_MODE_PROPERTY = "smallrye-messaging-strict-binding";
    private final CollectedMediatorMetadata collected = new CollectedMediatorMetadata();
    @Inject
    MediatorFactory mediatorFactory;
    @Inject
    BeanManager beanManager;
    @Inject
    WorkerPoolRegistry workerPoolRegistry;
    @Inject
    Instance<PublisherDecorator> decorators;
    @Inject
    Instance<SubscriberDecorator> subscriberDecorators;
    @Inject
    Instance<MessageConverter> converters;
    private final List<EmitterConfiguration> emitters = new ArrayList<EmitterConfiguration>();
    @Inject
    HealthCenter health;
    private final List<ChannelConfiguration> channels = new ArrayList<ChannelConfiguration>();
    @Inject
    ChannelRegistry registry;
    @Inject
    Wiring wiring;
    @Inject
    Instance<ChannelRegistar> registars;
    @Inject
    @ConfigProperty(name="smallrye-messaging-strict-binding", defaultValue="false")
    boolean strictMode;

    public <T> void analyze(AnnotatedType<T> annotatedType, Bean<T> bean) {
        if (this.strictMode) {
            this.collected.strict();
        }
        ProviderLogging.log.scanningType(annotatedType.getJavaClass());
        Set methods = annotatedType.getMethods();
        methods.stream().filter(this::hasMediatorAnnotations).forEach(method -> {
            if (this.shouldCollectMethod(method.getJavaMember(), this.collected)) {
                this.collected.add(method.getJavaMember(), bean);
            }
        });
    }

    public <T> void analyze(Class<?> beanClass, Bean<T> bean) {
        for (Class<?> current = beanClass; current != Object.class; current = current.getSuperclass()) {
            Arrays.stream(current.getDeclaredMethods()).filter(this::hasMediatorAnnotations).forEach(method -> {
                if (this.shouldCollectMethod((Method)method, this.collected)) {
                    this.collected.add((Method)method, bean);
                }
            });
        }
    }

    public void addAnalyzed(Collection<? extends MediatorConfiguration> mediators) {
        this.collected.addAll(mediators);
    }

    public void addEmitter(EmitterConfiguration emitterConfiguration) {
        this.emitters.add(emitterConfiguration);
    }

    public void addChannel(ChannelConfiguration channel) {
        this.channels.add(channel);
    }

    private boolean shouldCollectMethod(Method method, CollectedMediatorMetadata collected) {
        Optional<MediatorConfiguration> existing = collected.mediators().stream().filter(mc -> mc.getMethod().getDeclaringClass() == method.getDeclaringClass() && mc.getMethod().getName().equals(method.getName()) && this.areParametersEquivalent(method, mc.getMethod())).findAny();
        return !existing.isPresent();
    }

    private boolean areParametersEquivalent(Method method1, Method method2) {
        if (method1.getParameterCount() != method2.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < method1.getParameterCount(); ++i) {
            Class<?> type2;
            Class<?> type1 = method1.getParameterTypes()[i];
            if (type1.isAssignableFrom(type2 = method2.getParameterTypes()[i]) || type2.isAssignableFrom(type1)) continue;
            return false;
        }
        return true;
    }

    private <T> boolean hasMediatorAnnotations(AnnotatedMethod<? super T> method) {
        return method.isAnnotationPresent(Incomings.class) || method.isAnnotationPresent(Incoming.class) || method.isAnnotationPresent(Outgoing.class);
    }

    private boolean hasMediatorAnnotations(Method m) {
        return m.isAnnotationPresent(Incomings.class) || m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class);
    }

    public AbstractMediator createMediator(MediatorConfiguration configuration) {
        AbstractMediator mediator = this.mediatorFactory.create(configuration);
        mediator.setDecorators(this.decorators);
        mediator.setSubscriberDecorators(this.subscriberDecorators);
        mediator.setConverters(this.converters);
        mediator.setHealth(this.health);
        mediator.setWorkerPoolRegistry(this.workerPoolRegistry);
        try {
            Object beanInstance = this.beanManager.getReference(configuration.getBean(), Object.class, this.beanManager.createCreationalContext((Contextual)configuration.getBean()));
            if (configuration.getInvokerClass() != null) {
                try {
                    Constructor constructorUsingBeanInstance = configuration.getInvokerClass().getConstructor(Object.class);
                    if (constructorUsingBeanInstance != null) {
                        mediator.setInvoker((Invoker)constructorUsingBeanInstance.newInstance(beanInstance));
                    } else {
                        mediator.setInvoker((Invoker)configuration.getInvokerClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    ProviderLogging.log.unableToCreateInvoker(configuration.getInvokerClass(), e);
                    throw e;
                }
            }
            mediator.initialize(beanInstance);
        }
        catch (Throwable e) {
            ProviderLogging.log.unableToInitializeMediator(mediator.getMethodAsString(), e);
            throw new DefinitionException(e);
        }
        return mediator;
    }

    public void start() {
        this.registars.stream().forEach(ChannelRegistar::initialize);
        this.wiring.prepare(this.strictMode, this.registry, this.emitters, this.channels, this.collected.mediators());
        Graph graph = this.wiring.resolve();
        if (graph.hasWiringErrors()) {
            DeploymentException composite = new DeploymentException("Wiring error(s) detected in application.");
            for (Exception error : graph.getWiringErrors()) {
                composite.addSuppressed((Throwable)error);
            }
            throw composite;
        }
        graph.materialize(this.registry);
        this.health.markInitialized();
    }

    CollectedMediatorMetadata getCollected() {
        return this.collected;
    }
}

