/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;

public class ObjectExternalizer<T>
implements Externalizer<T> {
    private final Function<Object, T> reader;
    private final Function<T, Object> writer;
    private final Class<T> targetClass;

    public ObjectExternalizer(Class<T> targetClass, Function<Object, T> reader, Function<T, Object> writer) {
        this.targetClass = targetClass;
        this.reader = reader;
        this.writer = writer;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeObject(this.writer.apply(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.reader.apply(input.readObject());
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

