/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.ExternalizerProvider;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;
import org.wildfly.clustering.marshalling.spi.net.InetAddressExternalizer;
import org.wildfly.clustering.marshalling.spi.net.InetSocketAddressExternalizer;
import org.wildfly.clustering.marshalling.spi.net.URLExternalizer;

public enum NetExternalizerProvider implements ExternalizerProvider
{
    INET_ADDRESS(new InetAddressExternalizer<InetAddress>(InetAddress.class, OptionalInt.empty())),
    INET4_ADDRESS(new InetAddressExternalizer<Inet4Address>(Inet4Address.class, OptionalInt.of(4))),
    INET6_ADDRESS(new InetAddressExternalizer<Inet6Address>(Inet6Address.class, OptionalInt.of(16))),
    INET_SOCKET_ADDRESS(new InetSocketAddressExternalizer()),
    URI(new StringExternalizer<URI>(URI.class, URI::create, URI::toString)),
    URL(new URLExternalizer());

    private final Externalizer<?> externalizer;

    private NetExternalizerProvider(Externalizer<?> externalizer) {
        this.externalizer = externalizer;
    }

    @Override
    public Externalizer<?> getExternalizer() {
        return this.externalizer;
    }
}

