/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.wildfly.clustering.context.ClassLoaderContextualizerFactory;
import org.wildfly.clustering.context.CompositeContextualizer;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ContextualizerFactory;

public enum DefaultContextualizerFactory implements ContextualizerFactory
{
    INSTANCE;

    private final List<ContextualizerFactory> factories = new LinkedList<ContextualizerFactory>();

    private DefaultContextualizerFactory() {
        this.factories.add(new ClassLoaderContextualizerFactory());
        for (ContextualizerFactory factory : ServiceLoader.load(ContextualizerFactory.class, ContextualizerFactory.class.getClassLoader())) {
            this.factories.add(factory);
        }
    }

    @Override
    public Contextualizer createContextualizer(ClassLoader loader) {
        ArrayList<Contextualizer> contextualizers = new ArrayList<Contextualizer>(this.factories.size());
        for (ContextualizerFactory factory : this.factories) {
            contextualizers.add(factory.createContextualizer(loader));
        }
        return new CompositeContextualizer(contextualizers);
    }
}

