/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.text.DecimalFormat;

public enum SizeUnit {
    BYTE(null, "B"){

        @Override
        public String toString(long size) {
            return size + "B";
        }
    }
    ,
    KILOBYTE(BYTE, "KB"),
    MEGABYTE(KILOBYTE, "MB"),
    GIGABYTE(MEGABYTE, "GB"),
    TERABYTE(GIGABYTE, "TB"),
    PETABYTE(TERABYTE, "PB"),
    EXABYTE(TERABYTE, "EB");

    private static final DecimalFormat FORMAT;
    private final SizeUnit parent;
    private final long sizeInBytes;
    private final String abbreviation;

    private SizeUnit(SizeUnit parent, String abbreviation) {
        this.parent = parent;
        this.sizeInBytes = parent == null ? 1L : parent.sizeInBytes << 10;
        this.abbreviation = abbreviation;
    }

    public String abbreviation() {
        return this.abbreviation;
    }

    public long toBytes(long size) {
        return Math.multiplyExact(this.sizeInBytes, size);
    }

    public double convert(long size, SizeUnit unit) {
        if (unit == BYTE) {
            return this.toBytes(size);
        }
        long bytes = this.toBytes(size);
        return (double)bytes / (double)unit.sizeInBytes;
    }

    public String toString(long size) {
        return FORMAT.format((double)size / (double)this.sizeInBytes) + this.abbreviation;
    }

    public SizeUnit parent() {
        return this.parent;
    }

    public static String toHumanReadable(long size) {
        if (size == 0L) {
            return "0B";
        }
        SizeUnit[] values = SizeUnit.values();
        for (int i = values.length - 1; i >= 0; --i) {
            SizeUnit unit = values[i];
            if (size < unit.sizeInBytes) continue;
            return unit.toString(size);
        }
        return size + "B";
    }

    static {
        FORMAT = new DecimalFormat("#.##");
    }
}

