/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.wildfly.httpclient.common.HostPool;
import org.wildfly.httpclient.common.PoolAuthenticationContext;
import org.wildfly.httpclient.common.Protocol;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class HttpConnectionPool
implements Closeable {
    private final int maxConnections;
    private final int maxStreamsPerConnection;
    private final XnioWorker worker;
    private final ByteBufferPool byteBufferPool;
    private final OptionMap options;
    private final HostPool hostPool;
    private final long connectionIdleTimeout;
    private final Map<Object, ConcurrentLinkedDeque<ClientConnectionHolder>> connections = new ConcurrentHashMap<Object, ConcurrentLinkedDeque<ClientConnectionHolder>>();
    private final ConcurrentLinkedDeque<RequestHolder> pendingConnectionRequests = new ConcurrentLinkedDeque();
    private final AtomicInteger activeInvocationCount = new AtomicInteger();
    private final Map<SSLContext, UndertowXnioSsl> sslInstances = new ConcurrentHashMap<SSLContext, UndertowXnioSsl>();
    private final Object NULL_SSL_CONTEXT = new Object();
    private final PoolAuthenticationContext poolAuthenticationContext = new PoolAuthenticationContext();

    public HttpConnectionPool(int maxConnections, int maxStreamsPerConnection, XnioWorker worker, ByteBufferPool byteBufferPool, OptionMap options, HostPool hostPool, long connectionIdleTimeout) {
        this.maxConnections = maxConnections;
        this.maxStreamsPerConnection = maxStreamsPerConnection;
        this.worker = worker;
        this.byteBufferPool = byteBufferPool;
        this.hostPool = hostPool;
        this.connectionIdleTimeout = connectionIdleTimeout;
        String hostname = hostPool.getUri().getHost();
        if ("https".equals(hostPool.getUri().getScheme()) && hostname != null) {
            try {
                InetAddress address = hostPool.getAddress().getAddress();
                if (address.toString().charAt(0) != '/') {
                    options = OptionMap.builder().addAll(options).set(UndertowOptions.SSL_SNI_HOSTNAME, hostname).getMap();
                }
            }
            catch (UnknownHostException e) {
                options = OptionMap.builder().addAll(options).set(UndertowOptions.SSL_SNI_HOSTNAME, hostname).getMap();
            }
        }
        this.options = options;
    }

    public void getConnection(ConnectionListener connectionListener, ErrorListener errorListener, boolean ignoreConnectionLimits, SSLContext sslContext) {
        this.pendingConnectionRequests.add(new RequestHolder(connectionListener, errorListener, ignoreConnectionLimits, sslContext));
        this.runPending();
    }

    public void returnConnection(ClientConnectionHolder connection) {
        this.activeInvocationCount.decrementAndGet();
        if (connection.getConnection().isOpen()) {
            this.connections.get(connection.sslContext == null ? this.NULL_SSL_CONTEXT : connection.sslContext).add(connection);
        }
        this.runPending();
    }

    protected ClientConnectionHolder createClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
        return new ClientConnectionHolder(connection, uri, sslContext);
    }

    int getProtocolVersion() {
        return Protocol.LATEST;
    }

    private void runPending() {
        InetAddress address;
        ClientConnectionHolder existingConnection;
        Object key;
        ConcurrentLinkedDeque<ClientConnectionHolder> queue;
        int count;
        do {
            if ((count = this.activeInvocationCount.get()) != this.maxConnections) continue;
            return;
        } while (!this.activeInvocationCount.compareAndSet(count, count + 1));
        final RequestHolder next = this.pendingConnectionRequests.poll();
        if (next == null) {
            this.activeInvocationCount.decrementAndGet();
            return;
        }
        SSLContext sslContext = null;
        UndertowXnioSsl ssl = null;
        if (this.hostPool.getUri().getScheme().equals("https") && (sslContext = next.context) != null && (ssl = this.sslInstances.get(sslContext)) == null) {
            ssl = new UndertowXnioSsl(this.worker.getXnio(), OptionMap.EMPTY, sslContext);
            this.sslInstances.put(sslContext, ssl);
        }
        if ((queue = this.connections.get(key = sslContext == null ? this.NULL_SSL_CONTEXT : sslContext)) == null) {
            this.connections.putIfAbsent(key, new ConcurrentLinkedDeque());
            queue = this.connections.get(key);
        }
        while ((existingConnection = queue.poll()) != null) {
            if (!existingConnection.connection.isOpen() || !existingConnection.tryAcquire()) continue;
            next.connectionListener.done(existingConnection);
            return;
        }
        final HostPool.AddressResult hostPoolAddress = this.hostPool.getAddress();
        try {
            address = hostPoolAddress.getAddress();
        }
        catch (UnknownHostException e) {
            next.errorListener.error(e);
            return;
        }
        try {
            final SSLContext context = sslContext;
            UndertowClient.getInstance().connect(new ClientCallback<ClientConnection>(){

                @Override
                public void completed(ClientConnection result) {
                    result.getCloseSetter().set(HttpConnectionPool.this.connections::remove);
                    ClientConnectionHolder clientConnectionHolder = HttpConnectionPool.this.createClientConnectionHolder(result, hostPoolAddress.getURI(), context);
                    clientConnectionHolder.tryAcquire();
                    next.connectionListener.done(clientConnectionHolder);
                }

                @Override
                public void failed(IOException e) {
                    hostPoolAddress.failed();
                    HttpConnectionPool.this.activeInvocationCount.decrementAndGet();
                    next.errorListener.error(e);
                }
            }, new URI(hostPoolAddress.getURI().getScheme(), hostPoolAddress.getURI().getUserInfo(), address.getHostAddress(), hostPoolAddress.getURI().getPort(), "/", null, null), this.worker, (XnioSsl)ssl, this.byteBufferPool, this.options);
        }
        catch (URISyntaxException e) {
            next.errorListener.error(e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected class ClientConnectionHolder
    implements ConnectionHandle {
        private volatile AtomicInteger state = new AtomicInteger();
        private final ClientConnection connection;
        private final URI uri;
        private volatile XnioExecutor.Key timeoutKey;
        private long timeout;
        private final SSLContext sslContext;
        private static final int IN_USE = 1;
        private static final int CLOSED = 2;
        private final Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                ClientConnectionHolder.this.timeoutKey = null;
                if (ClientConnectionHolder.this.hasFlags(2)) {
                    return;
                }
                long time = System.currentTimeMillis();
                if (ClientConnectionHolder.this.timeout > time) {
                    ClientConnectionHolder.this.timeoutKey = ClientConnectionHolder.this.connection.getIoThread().executeAfter(this, ClientConnectionHolder.this.timeout - time, TimeUnit.MILLISECONDS);
                    return;
                }
                if (ClientConnectionHolder.this.tryClose()) {
                    HttpConnectionPool.this.activeInvocationCount.decrementAndGet();
                    HttpConnectionPool.this.runPending();
                }
            }
        };

        ClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
            this.connection = connection;
            this.uri = uri;
            this.sslContext = sslContext;
        }

        final boolean tryClose() {
            if (this.setFlagsIfCleared(2, 1)) {
                IoUtils.safeClose((Closeable)this.connection);
                return true;
            }
            return false;
        }

        final boolean tryAcquire() {
            return this.setFlagsIfCleared(1, 2);
        }

        @Override
        public ClientConnection getConnection() {
            return this.connection;
        }

        @Override
        public void done(boolean close) {
            if (!this.clearFlags(1)) {
                return;
            }
            if (close) {
                IoUtils.safeClose((Closeable)this.connection);
            }
            this.timeout = System.currentTimeMillis() + HttpConnectionPool.this.connectionIdleTimeout;
            if (this.timeoutKey == null && HttpConnectionPool.this.connectionIdleTimeout > 0L && !close) {
                this.timeoutKey = this.connection.getIoThread().executeAfter(this.timeoutTask, HttpConnectionPool.this.connectionIdleTimeout, TimeUnit.MILLISECONDS);
            }
            HttpConnectionPool.this.returnConnection(this);
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public PoolAuthenticationContext getAuthenticationContext() {
            return HttpConnectionPool.this.poolAuthenticationContext;
        }

        @Override
        public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> callback) {
            this.connection.sendRequest(request, callback);
        }

        protected final void setFlags(int flags) {
            int oldState;
            do {
                if (((oldState = this.state.get()) & flags) != flags && (oldState & 2) != 2) continue;
                return;
            } while (!this.state.compareAndSet(oldState, oldState | flags));
        }

        protected final boolean setFlagsIfCleared(int flags, int clearedFlags) {
            int oldState;
            do {
                if (((oldState = this.state.get()) & flags) != flags && (oldState & clearedFlags) != clearedFlags) continue;
                return false;
            } while (!this.state.compareAndSet(oldState, oldState | flags));
            return true;
        }

        protected final boolean clearFlags(int flags) {
            int oldState;
            do {
                if (((oldState = this.state.get()) & flags) != 0) continue;
                return false;
            } while (!this.state.compareAndSet(oldState, oldState & ~flags));
            return true;
        }

        protected final boolean hasFlags(int flags) {
            return (this.state.get() & flags) == flags;
        }
    }

    private static class RequestHolder {
        final ConnectionListener connectionListener;
        final ErrorListener errorListener;
        final boolean ignoreConnectionLimits;
        final SSLContext context;

        private RequestHolder(ConnectionListener connectionListener, ErrorListener errorListener, boolean ignoreConnectionLimits, SSLContext context) {
            this.connectionListener = connectionListener;
            this.errorListener = errorListener;
            this.ignoreConnectionLimits = ignoreConnectionLimits;
            this.context = context;
        }
    }

    public static interface ConnectionHandle {
        public ClientConnection getConnection();

        public void done(boolean var1);

        public URI getUri();

        public PoolAuthenticationContext getAuthenticationContext();

        public void sendRequest(ClientRequest var1, ClientCallback<ClientExchange> var2);
    }

    public static interface ErrorListener {
        public void error(Exception var1);
    }

    public static interface ConnectionListener {
        public void done(ConnectionHandle var1);
    }
}

