/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime;

import jakarta.batch.runtime.BatchStatus;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractExecution
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected long version;
    protected long startTime;
    protected long endTime;
    protected String exitStatus;
    protected BatchStatus batchStatus;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Date getStartTime() {
        long startTime = this.startTime;
        if (startTime > 0L) {
            return new Date(startTime);
        }
        return null;
    }

    public Date getEndTime() {
        if (this.endTime > 0L) {
            return new Date(this.endTime);
        }
        return null;
    }

    public String getExitStatus() {
        if (this.exitStatus != null) {
            return this.exitStatus;
        }
        if (this.batchStatus != null && (this.batchStatus == BatchStatus.COMPLETED || this.batchStatus == BatchStatus.FAILED || this.batchStatus == BatchStatus.ABANDONED || this.batchStatus == BatchStatus.STOPPED)) {
            return this.batchStatus.name();
        }
        return null;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
        switch (batchStatus) {
            case STARTED: {
                this.startTime = System.currentTimeMillis();
                break;
            }
            case COMPLETED: 
            case FAILED: 
            case STOPPED: {
                this.endTime = System.currentTimeMillis();
            }
        }
    }
}

