/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;
import org.jboss.logging.Logger;

public class ManagedConnectionPoolFactory {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)ManagedConnectionPoolFactory.class.getName());
    public static final String DEFAULT_IMPLEMENTATION = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool";
    public static final String EXPERIMENTAL_IMPLEMENTATION = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreConcurrentLinkedDequeManagedConnectionPool";
    private static final String[] DEPRECATED_IMPLEMENTATIONS = new String[]{"org.jboss.jca.core.connectionmanager.pool.mcp.ArrayBlockingQueueManagedConnectionPool", "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreConcurrentLinkedQueueManagedConnectionPool"};
    private static Class<?> defaultImplementation;
    private static boolean override;

    public String getDefaultImplementation() {
        return defaultImplementation.getName();
    }

    public boolean isOverride() {
        return override;
    }

    public ManagedConnectionPool create(ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) throws Throwable {
        ManagedConnectionPool mcp = (ManagedConnectionPool)defaultImplementation.newInstance();
        return this.init(mcp, mcf, cm, subject, cri, pc, p);
    }

    public ManagedConnectionPool create(String strategy, ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) throws Throwable {
        Class<?> clz = Class.forName(strategy, true, SecurityActions.getClassLoader(ManagedConnectionPoolFactory.class));
        ManagedConnectionPool mcp = (ManagedConnectionPool)clz.newInstance();
        return this.init(mcp, mcf, cm, subject, cri, pc, p);
    }

    private ManagedConnectionPool init(ManagedConnectionPool mcp, ManagedConnectionFactory mcf, ConnectionManager cm, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        mcp.initialize(mcf, cm, subject, cri, pc, p);
        return mcp;
    }

    static {
        String clz = SecurityActions.getSystemProperty("ironjacamar.mcp");
        if (clz != null && !clz.trim().equals("")) {
            clz = clz.trim();
            for (String impl : DEPRECATED_IMPLEMENTATIONS) {
                if (!clz.equals(impl)) continue;
                log.deprecatedPool(clz, EXPERIMENTAL_IMPLEMENTATION);
                clz = EXPERIMENTAL_IMPLEMENTATION;
            }
            override = true;
        } else {
            clz = DEFAULT_IMPLEMENTATION;
            override = false;
        }
        try {
            defaultImplementation = Class.forName(clz, true, SecurityActions.getClassLoader(ManagedConnectionPoolFactory.class));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load default managed connection pool implementation: " + clz);
        }
    }
}

