/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.logging;

import java.sql.Driver;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYJCA", length=4)
public interface ConnectorLogger
extends BasicLogger {
    public static final ConnectorLogger ROOT_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector");
    public static final ConnectorLogger DEPLOYER_JDBC_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployers.jdbc");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment.registry");
    public static final ConnectorLogger DS_DEPLOYER_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ConnectorLogger MDR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.services.mdr");
    public static final ConnectorLogger SUBSYSTEM_DATASOURCES_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.datasources");
    public static final ConnectorLogger SUBSYSTEM_RA_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.resourceadapters");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Bound data source [%s]")
    public void boundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Bound Jakarta Connectors %s [%s]")
    public void boundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Unable to instantiate driver class \"%s\": %s")
    public void cannotInstantiateDriverClass(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Deploying JDBC-compliant driver %s (version %d.%d)")
    public void deployingCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Deploying non-JDBC-compliant driver %s (version %d.%d)")
    public void deployingNonCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Registered admin object at %s")
    public void registeredAdminObject(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Registered connection factory %s")
    public void registeredConnectionFactory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Starting %s Subsystem (%s)")
    public void startingSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Unbound data source [%s]")
    public void unboundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Unbound Jakarta Connectors %s [%s]")
    public void unboundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="<drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s")
    public void driversElementNotSupported(String var1);

    @Message(id=15, value="the attribute driver-name (%s) cannot be different from driver resource name (%s)")
    public OperationFailedException driverNameAndResourceNameNotEquals(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="Method %s on DataSource class %s not found. Ignoring")
    public void methodNotFoundOnDataSource(String var1, Class<?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17, value="Forcing ironjacamar.xml descriptor to null")
    public void forceIJToNull();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Started Driver service with driver-name = %s")
    public void startedDriverService(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Stopped Driver service with driver-name = %s")
    public void stoppedDriverService(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Unsupported selector's option: %s")
    public void unsupportedSelectorOption(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Unsupported policy's option: %s")
    public void unsupportedPolicyOption(String var1);

    @Message(id=22, value="Failed to start JGroups channel %s for distributed workmanager %s")
    public StartException failedToStartJGroupsChannel(String var1, String var2);

    @Message(id=23, value="Cannot find WorkManager %s or it isn't a distributed workmanager. Only DWM can override configurations")
    public OperationFailedException failedToFindDistributedWorkManager(String var1);

    @Message(id=24, value="Failed to start JGroups transport for distributed workmanager %s")
    public StartException failedToStartDWMTransport(String var1);

    @Message(id=25, value="Unsupported selector's option: %s")
    public OperationFailedException unsupportedSelector(String var1);

    @Message(id=26, value="Unsupported policy's option: %s")
    public OperationFailedException unsupportedPolicy(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=27, value="No ironjacamar.security defined for %s")
    public void noSecurityDefined(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=28, value="@ConnectionFactoryDefinition will have limited management: %s")
    public void connectionFactoryAnnotation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=29, value="@AdministeredObjectDefinition will have limited management: %s")
    public void adminObjectAnnotation(String var1);

    @Message(id=30, value="unable to deploy")
    public DeployException cannotDeploy(@Cause Throwable var1);

    @Message(id=31, value="unable to validate and deploy ds or xads")
    public DeployException cannotDeployAndValidate(@Cause Throwable var1);

    @Message(id=33, value="Error during the deployment of %s")
    public StartException deploymentError(@Cause Throwable var1, String var2);

    @Message(id=34, value="Unable to instantiate driver class \"%s\". See log (WARN) for more details")
    public String cannotInstantiateDriverClass(String var1);

    @Message(id=35, value="Specified driver version doesn't match with actual driver version")
    public IllegalStateException driverVersionMismatch();

    @Message(id=36, value="Failed to create %s instance for [%s]%n reason: %s")
    public String failedToCreate(String var1, ModelNode var2, String var3);

    @Message(id=37, value="failed to get metrics: %s")
    public String failedToGetMetrics(String var1);

    @Message(id=39, value="failed to get url delimiter")
    public DeployException failedToGetUrlDelimiter(@Cause Throwable var1);

    @Message(id=40, value="failed to invoke operation: %s")
    public String failedToInvokeOperation(String var1);

    @Message(id=41, value="Failed to load module for driver [%s]")
    public String failedToLoadModuleDriver(String var1);

    @Message(id=42, value="failed to match pool. Check JndiName: %s")
    public IllegalArgumentException failedToMatchPool(String var1);

    @Message(id=43, value="Failed to parse service xml [%s]")
    public DeploymentUnitProcessingException failedToParseServiceXml(VirtualFile var1);

    public DeploymentUnitProcessingException failedToParseServiceXml(@Cause Throwable var1, VirtualFile var2);

    @Message(id=44, value="Failed to process RA child archives for [%s]")
    public DeploymentUnitProcessingException failedToProcessRaChild(@Cause Throwable var1, VirtualFile var2);

    @Message(id=45, value="failed to set attribute: %s")
    public String failedToSetAttribute(String var1);

    @Message(id=46, value="Failed to start RA deployment [%s]")
    public StartException failedToStartRaDeployment(@Cause Throwable var1, String var2);

    @Message(id=47, value="Connection is not valid")
    public IllegalStateException invalidConnection(@Cause Exception var1);

    @Message(id=49, value="Non-explicit JNDI bindings not supported")
    public IllegalStateException jndiBindingsNotSupported();

    @Message(id=50, value="no metrics available")
    public String noMetricsAvailable();

    @Message(id=51, value="%s should be an annotation")
    public IllegalArgumentException notAnAnnotation(Class<?> var1);

    @Message(id=52, value="%s is null")
    public String nullVar(String var1);

    @Message(id=53, value="%s service [%s] is already started")
    public String serviceAlreadyStarted(String var1, Object var2);

    @Message(id=54, value="%s service [%s] is not available")
    public String serviceNotAvailable(String var1, Object var2);

    @Message(id=56, value="Service not started")
    public IllegalStateException serviceNotStarted();

    @Message(id=58, value="%s is undefined")
    public IllegalArgumentException undefinedVar(String var1);

    @Message(id=61, value="Failed to load native libraries")
    public DeploymentUnitProcessingException failedToLoadNativeLibraries(@Cause Throwable var1);

    @Message(id=64, value="Exception deploying datasource %s")
    public DeploymentUnitProcessingException exceptionDeployingDatasource(@Cause Throwable var1, String var2);

    @Message(id=65, value="No DataSource exists at address %s")
    public String noDataSourceRegisteredForAddress(PathAddress var1);

    @Message(id=66, value="Unknown attribute %s")
    public IllegalStateException unknownAttribute(String var1);

    @Message(id=67, value="Unknown operation %s")
    public IllegalStateException unknownOperation(String var1);

    @Message(id=69, value="At least one xa-datasource-property is required for an xa-datasource")
    public OperationFailedException xaDataSourcePropertiesNotPresent();

    @Message(id=72, value="Deployment %s failed")
    public DeployException deploymentFailed(@Cause Throwable var1, String var2);

    @Message(id=73, value="Failed to load module for RA [%s] Cause: %s")
    public String failedToLoadModuleRA(String var1, String var2);

    @Message(id=74, value="Method %s not found")
    public NoSuchMethodException noSuchMethod(String var1);

    @Message(id=75, value="Field %s not found")
    public NoSuchMethodException noSuchField(String var1);

    @Message(id=76, value="Unknown property resolution for property %s")
    public IllegalArgumentException noPropertyResolution(String var1);

    @Message(id=77, value="At least one of ARCHIVE or MODULE is required")
    public OperationFailedException archiveOrModuleRequired();

    @Message(id=78, value="Rar are supported only in uncompressed form. Failed to load module for RA [%s]")
    public String compressedRarNotSupportedInModuleRA(String var1);

    @Message(id=79, value="Failed to deploy datasource %s because driver is not specified")
    public DeploymentUnitProcessingException FailedDeployDriverNotSpecified(String var1);

    @Message(id=80, value="RAR '%s' not yet deployed.")
    public OperationFailedException RARNotYetDeployed(String var1);

    @Message(id=83, value="Connection factory interface (%s) is incorrect for resource adapter '%s' while deploying %s")
    public DeploymentUnitProcessingException invalidConnectionFactory(String var1, String var2, String var3);

    @Message(id=84, value="Admin object declared for JCA 1.0 resource adapter '%s' while deploying %s")
    public DeploymentUnitProcessingException adminObjectForJCA10(String var1, String var2);

    @Message(id=85, value="Admin object class (%s) is incorrect for resource adapter '%s' while deploying %s")
    public DeploymentUnitProcessingException invalidAdminObject(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=86, value="Unable to find driver class name in \"%s\" jar")
    public void cannotFindDriverClassName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=87, value="Unable to register recovery: %s (%s)")
    public void unableToRegisterRecovery(String var1, boolean var2);

    @Message(id=88, value="Attributes %s rejected. Must be true")
    public String rejectAttributesMustBeTrue(Set<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=89, value="Exception during unregistering deployment")
    public void exceptionDuringUnregistering(@Cause NotFoundException var1);

    @Message(id=90, value="Jndi name shouldn't include '//' or end with '/'")
    public OperationFailedException jndiNameShouldValidate();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=91, value="-ds.xml file deployments are deprecated. Support may be removed in a future version.")
    public void deprecated();

    @Message(id=92, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=93, value="The '%s' operation is deprecated. Use of the 'add' or 'remove' operations is preferred, or if required the 'write-attribute' operation can used to set the deprecated 'enabled' attribute")
    public void legacyDisableEnableOperation(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=96, value="Error during recovery shutdown")
    public void errorDuringRecoveryShutdown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=97, value="Exception while stopping resource adapter")
    public void errorStoppingRA(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=98, value="Bound non-transactional data source: %s")
    public void boundNonJTADataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=99, value="Unbound non-transactional data source: %s")
    public void unBoundNonJTADataSource(String var1);

    @Message(id=100, value="Operation %s is not supported")
    public UnsupportedOperationException noSupportedOperation(String var1);

    @Message(id=101, value="Thread pool: %s(type: %s) can not be added for workmanager: %s, only one thread pool is allowed for each type.")
    public OperationFailedException oneThreadPoolWorkManager(String var1, String var2, String var3);

    @Message(id=102, value="Attribute %s can only be defined if %s is true")
    public OperationFailedException attributeRequiresTrueAttribute(String var1, String var2);

    @Message(id=103, value="Attribute %s can only be defined if %s is undefined or false")
    public OperationFailedException attributeRequiresFalseOrUndefinedAttribute(String var1, String var2);

    @Message(id=104, value="Subject=%s\nSubject identity=%s")
    public String subject(Subject var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=106, value="Elytron handler handle: %s")
    public void elytronHandlerHandle(String var1);

    @Message(id=107, value="Execution subject was not provided to the callback handler")
    public SecurityException executionSubjectNotSetInHandler();

    @Message(id=108, value="Supplied callback doesn't contain a security domain reference")
    public IllegalArgumentException invalidCallbackSecurityDomain();

    @Message(id=109, value="Callback with security domain is required - use createCallbackHandler(Callback callback) instead")
    public UnsupportedOperationException unsupportedCreateCallbackHandlerMethod();

    @Message(id=110, value="CredentialSourceSupplier is invalid for DSSecurity")
    public IllegalStateException invalidCredentialSourceSupplier(@Cause Throwable var1);

    @Message(id=111, value="WorkManager hasn't elytron-enabled flag set accordingly with RA one")
    public IllegalStateException invalidElytronWorkManagerSetting();

    @Message(id=112, value="Datasource %s is disabled")
    public IllegalArgumentException datasourceIsDisabled(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=113, value="Unexcepted error during worker execution : %s")
    public void unexceptedWorkerCompletionError(String var1, @Cause Throwable var2);

    @Message(id=114, value="Failed to load datasource class: %s")
    public OperationFailedException failedToLoadDataSourceClass(String var1, @Cause Throwable var2);

    @Message(id=115, value="Module for driver [%s] or one of it dependencies is missing: [%s]")
    public String missingDependencyInModuleDriver(String var1, String var2);

    @Message(id=116, value="Failed to load module for RA [%s] - the module or one of its dependencies is missing [%s]")
    public String raModuleNotFound(String var1, String var2);

    @Message(id=117, value="%s is not a valid %s implementation")
    public OperationFailedException notAValidDataSourceClass(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=118, value="Binding connection factory named %s to alias %s")
    public void bindingAlias(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=119, value="Unbinding connection factory named %s to alias %s")
    public void unbindingAlias(String var1, String var2);

    @Message(id=120, value="Unable to start the data source '%s' because there are no connection factories, either not defined or failed, please check log.")
    public StartException cannotStartDSNoConnectionFactory(String var1);

    @Message(id=121, value="Unable to start the data source '%s' because there is more than one(%s) connection factory defined.")
    public StartException cannotStartDSTooManyConnectionFactories(String var1, int var2);

    @Message(id=122, value="Thread pool name %s(type: %s) must match the workmanager name %s.")
    public OperationFailedException threadPoolNameMustMatchWorkManagerName(String var1, String var2, String var3);

    @Message(id=123, value="Connection definition %s from resource adapter %s is configured to require the legacy security subsystem, which is not present")
    public OperationFailedException legacySecurityNotAvailable(String var1, String var2);

    @Message(id=124, value="Datasource %s is configured to require the legacy security subsystem, which is not present")
    public OperationFailedException legacySecurityNotAvailable(String var1);

    @Message(id=125, value="Datasource %s is configured to require the legacy security subsystem, which is not present")
    public DeploymentUnitProcessingException legacySecurityNotAvailableForDsXml(String var1);

    @Message(id=126, value="Connection definition for %s is configured to require the legacy security subsystem, which is not present")
    public DeploymentUnitProcessingException legacySecurityNotAvailableForRa(String var1);

    @Message(id=127, value="Connection factory  %s is configured to require the legacy security subsystem, which is not present")
    public IllegalStateException legacySecurityNotAvailableForConnectionFactory(String var1);

    @Message(id=128, value="Legacy security is not available")
    public IllegalStateException legacySecurityNotAvailable();

    @Message(id=129, value="Wrong module name %s")
    public OperationFailedException wrongModuleName(@Cause ModuleLoadException var1, String var2);

    @Message(id=130, value="Report directory %s does not exist")
    public OperationFailedException reportDirectoryDoesNotExist(String var1);
}

