/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.falcon;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconSigner;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
    private FalconSigner signer;
    private SecureRandom random;

    protected SignatureSpi(FalconSigner falconSigner) {
        super("Falcon");
        this.signer = falconSigner;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCFalconPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to Falcon");
        }
        BCFalconPublicKey bCFalconPublicKey = (BCFalconPublicKey)publicKey;
        FalconPublicKeyParameters falconPublicKeyParameters = bCFalconPublicKey.getKeyParams();
        this.signer.init(false, falconPublicKeyParameters);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCFalconPrivateKey) {
            BCFalconPrivateKey bCFalconPrivateKey = (BCFalconPrivateKey)privateKey;
            FalconPrivateKeyParameters falconPrivateKeyParameters = bCFalconPrivateKey.getKeyParams();
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(falconPrivateKeyParameters, this.random));
            } else {
                this.signer.init(true, falconPrivateKeyParameters);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Falcon");
        }
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.bOut.write(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bOut.write(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Base
    extends SignatureSpi {
        public Base() throws NoSuchAlgorithmException {
            super(new FalconSigner());
        }
    }
}

