/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.spi.Limit;

public class SQLServer2005LimitHandler
extends AbstractLimitHandler {
    private boolean topAdded;

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean useMaxForLimit() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    @Override
    public String processSql(String sql, Limit limit) {
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        int selectOffset = Keyword.SELECT.rootOffset(sql);
        int afterSelectOffset = Keyword.SELECT.endOffset(sql, selectOffset);
        int fromOffset = Keyword.FROM.rootOffset(sql);
        boolean hasCommonTables = Keyword.WITH.occursAt(sql, 0);
        boolean hasOrderBy = Keyword.ORDER_BY.rootOffset(sql) > 0;
        boolean hasFirstRow = SQLServer2005LimitHandler.hasFirstRow(limit);
        StringBuilder result = new StringBuilder(sql);
        if (!hasFirstRow || hasOrderBy) {
            result.insert(afterSelectOffset, " top(?)");
            this.topAdded = true;
        }
        if (hasFirstRow) {
            String aliases = this.selectAliases(sql, afterSelectOffset, fromOffset, result);
            result.insert(selectOffset, (hasCommonTables ? "," : "with") + " query_ as (select row_.*,row_number() over (order by current_timestamp) as rownumber_ from (").append(") row_) select ").append(aliases).append(" from query_ where rownumber_>=? and rownumber_<?");
        }
        return result.toString();
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        if (this.topAdded) {
            statement.setInt(index, this.getMaxOrLimit(limit) - 1);
            return 1;
        }
        return 0;
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        return SQLServer2005LimitHandler.hasFirstRow(limit) ? super.bindLimitParametersAtEndOfQuery(limit, statement, index) : 0;
    }

    private String selectAliases(String sql, int afterSelectOffset, int fromOffset, StringBuilder result) {
        int nextOffset;
        LinkedList<String> aliases = new LinkedList<String>();
        int unique = 0;
        int offset = afterSelectOffset;
        do {
            String alias;
            String expression;
            String selectElement;
            int asIndex;
            if ((asIndex = Keyword.AS.rootOffset(selectElement = sql.substring(offset, nextOffset = this.nextElement(sql, offset, fromOffset)))) == 0) {
                expression = selectElement.trim();
                if (expression.equals("*") || expression.endsWith(".*")) {
                    alias = "";
                } else {
                    int aliasIndex = this.getAliasIndex(expression);
                    if (aliasIndex == -1) {
                        alias = StringHelper.generateAlias("col", unique++);
                        int diff = result.length() - sql.length();
                        if (result.charAt(nextOffset + diff - 1) == ' ') {
                            --diff;
                        }
                        result.insert(nextOffset + diff, " as " + alias);
                    } else {
                        alias = expression.substring(aliasIndex).trim();
                        expression = expression.substring(0, aliasIndex).trim();
                    }
                }
            } else {
                expression = selectElement.substring(0, asIndex).trim();
                alias = selectElement.substring(asIndex + 2).trim();
            }
            aliases.add(alias);
            if (!expression.endsWith("*")) continue;
            return "*";
        } while ((offset = nextOffset + 1) < fromOffset);
        return String.join((CharSequence)",", aliases);
    }

    private int getAliasIndex(String sql) {
        int endOffset = -1;
        int depth = 0;
        boolean quoted = false;
        boolean doubleQuoted = false;
        int offset = sql.length() - 1;
        while (offset > endOffset) {
            int nextQuote = sql.lastIndexOf(39, offset);
            if (nextQuote < 0 || nextQuote < endOffset) {
                nextQuote = endOffset;
            }
            if (!quoted) {
                block8: for (int index = offset; index > nextQuote; --index) {
                    char c = sql.charAt(index);
                    switch (c) {
                        case '(': {
                            --depth;
                            continue block8;
                        }
                        case ')': {
                            ++depth;
                            continue block8;
                        }
                        case '\"': {
                            doubleQuoted = !doubleQuoted;
                            continue block8;
                        }
                        case '[': {
                            doubleQuoted = false;
                            continue block8;
                        }
                        case ']': {
                            doubleQuoted = true;
                            continue block8;
                        }
                        default: {
                            if (!Character.isWhitespace(c) || depth != 0 || doubleQuoted) continue block8;
                            return index + 1;
                        }
                    }
                }
            }
            quoted = !quoted;
            offset = nextQuote - 1;
        }
        return -1;
    }

    private int nextElement(String sql, int startOffset, int endOffset) {
        int depth = 0;
        boolean quoted = false;
        boolean doubleQuoted = false;
        int offset = startOffset;
        while (offset < endOffset) {
            int nextQuote = sql.indexOf(39, offset);
            if (nextQuote < 0 || nextQuote > endOffset) {
                nextQuote = endOffset;
            }
            if (!quoted) {
                block9: for (int index = offset; index < nextQuote; ++index) {
                    switch (sql.charAt(index)) {
                        case '(': {
                            ++depth;
                            continue block9;
                        }
                        case ')': {
                            --depth;
                            continue block9;
                        }
                        case '\"': {
                            doubleQuoted = !doubleQuoted;
                            continue block9;
                        }
                        case '[': {
                            doubleQuoted = true;
                            continue block9;
                        }
                        case ']': {
                            doubleQuoted = false;
                            continue block9;
                        }
                        case ',': {
                            if (depth != 0 || doubleQuoted) continue block9;
                            return index;
                        }
                    }
                }
            }
            quoted = !quoted;
            offset = nextQuote + 1;
        }
        return endOffset;
    }

    static enum Keyword {
        SELECT("select(\\s+(distinct|all))?"),
        FROM("from"),
        ORDER_BY("order\\s+by"),
        AS("as"),
        WITH("with");

        Pattern pattern;

        private Keyword(String keyword) {
            this.pattern = Pattern.compile("^\\b" + keyword + "\\b", 2);
        }

        int rootOffset(String sql) {
            Matcher matcher = this.pattern.matcher(sql).useTransparentBounds(true);
            int depth = 0;
            boolean quoted = false;
            boolean doubleQuoted = false;
            int offset = 0;
            int end = sql.length();
            while (offset < end) {
                int nextQuote = sql.indexOf(39, offset);
                if (nextQuote < 0) {
                    nextQuote = end;
                }
                if (!quoted) {
                    block8: for (int index = offset; index < nextQuote; ++index) {
                        switch (sql.charAt(index)) {
                            case '(': {
                                ++depth;
                                continue block8;
                            }
                            case ')': {
                                --depth;
                                continue block8;
                            }
                            case '\"': {
                                doubleQuoted = !doubleQuoted;
                                continue block8;
                            }
                            case '[': {
                                doubleQuoted = true;
                                continue block8;
                            }
                            case ']': {
                                doubleQuoted = false;
                                continue block8;
                            }
                            default: {
                                if (depth != 0 || doubleQuoted) continue block8;
                                matcher.region(index, nextQuote);
                                if (!matcher.find()) continue block8;
                                return index;
                            }
                        }
                    }
                }
                quoted = !quoted;
                offset = nextQuote + 1;
            }
            return 0;
        }

        int endOffset(String sql, int startOffset) {
            Matcher matcher = this.pattern.matcher(sql).useTransparentBounds(true);
            matcher.region(startOffset, sql.length());
            matcher.find();
            return matcher.end();
        }

        boolean occursAt(String sql, int offset) {
            Matcher matcher = this.pattern.matcher(sql).useTransparentBounds(true);
            matcher.region(offset, sql.length());
            return matcher.find();
        }
    }
}

