/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmAggregateFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SelfRenderingSqmWindowFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqmFunctionDescriptor
implements SqmFunctionDescriptor {
    private final ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;
    private final FunctionArgumentTypeResolver functionArgumentTypeResolver;
    private final String name;

    public AbstractSqmFunctionDescriptor(String name) {
        this(name, null, null, null);
    }

    public AbstractSqmFunctionDescriptor(String name, ArgumentsValidator argumentsValidator) {
        this(name, argumentsValidator, null, null);
    }

    public AbstractSqmFunctionDescriptor(String name, ArgumentsValidator argumentsValidator, FunctionArgumentTypeResolver argumentTypeResolver) {
        this(name, argumentsValidator, null, argumentTypeResolver);
    }

    public AbstractSqmFunctionDescriptor(String name, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, FunctionArgumentTypeResolver argumentTypeResolver) {
        this.name = name;
        this.argumentsValidator = argumentsValidator == null ? StandardArgumentsValidators.NONE : argumentsValidator;
        this.returnTypeResolver = returnTypeResolver == null ? StandardFunctionReturnTypeResolvers.useFirstNonNull() : returnTypeResolver;
        this.functionArgumentTypeResolver = argumentTypeResolver == null ? StandardFunctionArgumentTypeResolvers.NULL : argumentTypeResolver;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature(String name) {
        return this.getReturnSignature() + name + this.getArgumentListSignature();
    }

    @Override
    public ArgumentsValidator getArgumentsValidator() {
        return this.argumentsValidator;
    }

    public FunctionReturnTypeResolver getReturnTypeResolver() {
        return this.returnTypeResolver;
    }

    public FunctionArgumentTypeResolver getArgumentTypeResolver() {
        return this.functionArgumentTypeResolver;
    }

    public String getReturnSignature() {
        String result = this.returnTypeResolver.getReturnType();
        return result.isEmpty() ? "" : result + " ";
    }

    public String getArgumentListSignature() {
        String args = this.argumentsValidator.getSignature();
        return this.alwaysIncludesParentheses() ? args : ("()".equals(args) ? "" : "[" + args + "]");
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateSqmExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments, this.getName(), typeConfiguration);
        return this.generateSqmFunctionExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateAggregateSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments, this.getName(), typeConfiguration);
        return this.generateSqmAggregateFunctionExpression(arguments, filter, impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateOrderedSetAggregateSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments, this.getName(), typeConfiguration);
        return this.generateSqmOrderedSetAggregateFunctionExpression(arguments, filter, withinGroupClause, impliedResultType, queryEngine, typeConfiguration);
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> generateWindowSqmExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        this.argumentsValidator.validate(arguments, this.getName(), typeConfiguration);
        return this.generateSqmWindowFunctionExpression(arguments, filter, respectNulls, fromFirst, impliedResultType, queryEngine, typeConfiguration);
    }

    protected abstract <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> var1, ReturnableType<T> var2, QueryEngine var3, TypeConfiguration var4);

    protected <T> SelfRenderingSqmAggregateFunction<T> generateSqmAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return (SelfRenderingSqmAggregateFunction)this.generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    protected <T> SelfRenderingSqmAggregateFunction<T> generateSqmOrderedSetAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return (SelfRenderingSqmAggregateFunction)this.generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }

    protected <T> SelfRenderingSqmWindowFunction<T> generateSqmWindowFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, Boolean respectNulls, Boolean fromFirst, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return (SelfRenderingSqmWindowFunction)this.generateSqmExpression(arguments, impliedResultType, queryEngine, typeConfiguration);
    }
}

