/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.Collection;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RequestControllerDeploymentUnitProcessor;
import org.wildfly.extension.requestcontroller.RequestControllerRootDefinition;

class RequestControllerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    RequestControllerSubsystemAdd(Collection<AttributeDefinition> attributeDefinitions) {
        super(attributeDefinitions);
    }

    public void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("request-controller", Phase.STRUCTURE, 8192, (DeploymentUnitProcessor)new RequestControllerDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        int maxRequests = RequestControllerRootDefinition.MAX_REQUESTS.resolveModelAttribute(context, resource.getModel()).asInt();
        boolean trackIndividual = RequestControllerRootDefinition.TRACK_INDIVIDUAL_ENDPOINTS.resolveModelAttribute(context, resource.getModel()).asBoolean();
        CapabilityServiceBuilder svcBuilder = context.getCapabilityServiceTarget().addCapability(RequestControllerRootDefinition.REQUEST_CONTROLLER_CAPABILITY);
        Supplier supplier = svcBuilder.requiresCapability("org.wildfly.server.suspend-controller", SuspendController.class, new String[0]);
        RequestController requestController = new RequestController(trackIndividual, supplier);
        requestController.setMaxRequestCount(maxRequests);
        svcBuilder.setInstance((Service)requestController).install();
    }
}

