/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;

public class ManagedConnectionFactoryConfigurationBuilder<S extends AbstractJdbcStoreConfigurationBuilder<?, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<S>
implements ConnectionFactoryConfigurationBuilder<ManagedConnectionFactoryConfiguration> {
    private final AttributeSet attributes = ManagedConnectionFactoryConfiguration.attributeSet();

    public ManagedConnectionFactoryConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, S> builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void jndiUrl(String jndiUrl) {
        this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).set((Object)jndiUrl);
    }

    public void validate() {
        String jndiUrl = (String)this.attributes.attribute(ManagedConnectionFactoryConfiguration.JNDI_URL).get();
        if (jndiUrl == null) {
            throw new CacheConfigurationException("The jndiUrl has not been specified");
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public ManagedConnectionFactoryConfiguration create() {
        return new ManagedConnectionFactoryConfiguration(this.attributes.protect());
    }

    public ManagedConnectionFactoryConfigurationBuilder<S> read(ManagedConnectionFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

