/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.StrongCounterConfiguration;
import org.infinispan.counter.configuration.WeakCounterConfiguration;

public class CounterConfigurationSerializer
implements ConfigurationSerializer<CounterManagerConfiguration> {
    public void serialize(ConfigurationWriter writer, CounterManagerConfiguration configuration) {
        if (writer.hasFeature(ConfigurationFormatFeature.MIXED_ELEMENTS)) {
            writer.writeStartMap((Enum)Element.COUNTERS);
            writer.writeDefaultNamespace("urn:infinispan:config:counters:" + Version.getMajorMinor());
            configuration.attributes().write(writer);
            this.writeConfigurations(writer, configuration.counters().values());
            writer.writeEndMap();
        } else {
            writer.writeStartElement((Enum)Element.COUNTERS);
            writer.writeDefaultNamespace("urn:infinispan:config:counters:" + Version.getMajorMinor());
            configuration.attributes().write(writer);
            writer.writeStartMap((Enum)Element.COUNTERS);
            this.writeConfigurations(writer, configuration.counters().values());
            writer.writeEndMap();
            writer.writeEndElement();
        }
    }

    public void serializeConfigurations(OutputStream os, Collection<AbstractCounterConfiguration> configs) {
        BufferedOutputStream output = new BufferedOutputStream(os);
        ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)output).build();
        writer.writeStartDocument();
        writer.writeStartMap((Enum)Element.COUNTERS);
        this.writeConfigurations(writer, configs);
        writer.writeEndMap();
        writer.writeEndDocument();
        Util.close((AutoCloseable)writer);
    }

    public void serializeConfiguration(ConfigurationWriter writer, AbstractCounterConfiguration c) {
        writer.writeStartDocument();
        this.writeConfiguration(writer, c, true);
        writer.writeEndDocument();
    }

    private void writeConfigurations(ConfigurationWriter writer, Collection<AbstractCounterConfiguration> configs) {
        for (AbstractCounterConfiguration c : configs) {
            this.writeConfiguration(writer, c, false);
        }
    }

    private void writeConfiguration(ConfigurationWriter writer, AbstractCounterConfiguration c, boolean unnamed) {
        if (c instanceof StrongCounterConfiguration) {
            this.writeStrongConfiguration((StrongCounterConfiguration)c, writer, unnamed);
        } else if (c instanceof WeakCounterConfiguration) {
            this.writeWeakConfiguration((WeakCounterConfiguration)c, writer, unnamed);
        }
    }

    private void writeWeakConfiguration(WeakCounterConfiguration configuration, ConfigurationWriter writer, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)Element.WEAK_COUNTER);
        } else {
            writer.writeMapItem((Enum)Element.WEAK_COUNTER, (Enum)Attribute.NAME, configuration.name());
        }
        configuration.attributes().write(writer);
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }

    private void writeStrongConfiguration(StrongCounterConfiguration configuration, ConfigurationWriter writer, boolean unnamed) {
        if (unnamed) {
            writer.writeStartElement((Enum)Element.STRONG_COUNTER);
        } else {
            writer.writeMapItem((Enum)Element.STRONG_COUNTER, (Enum)Attribute.NAME, configuration.name());
        }
        configuration.attributes().write(writer);
        if (unnamed) {
            writer.writeEndElement();
        } else {
            writer.writeEndMapItem();
        }
    }
}

